/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.synonyms.GetSynonymsAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetSynonymsAction
extends HandledTransportAction<GetSynonymsAction.Request, GetSynonymsAction.Response> {
    private final SynonymsManagementAPIService synonymsManagementAPIService;

    @Inject
    public TransportGetSynonymsAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/synonyms/get", transportService, actionFilters, GetSynonymsAction.Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.synonymsManagementAPIService = new SynonymsManagementAPIService(client);
    }

    @Override
    protected void doExecute(Task task, GetSynonymsAction.Request request, ActionListener<GetSynonymsAction.Response> listener) {
        this.synonymsManagementAPIService.getSynonymSetRules(request.synonymsSetId(), request.from(), request.size(), listener.map(GetSynonymsAction.Response::new));
    }
}

