/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.support.InvalidSelectorException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;

public enum IndexComponentSelector implements Writeable
{
    DATA("data", 0),
    FAILURES("failures", 1);

    private static final TransportVersion REMOVE_ALL_APPLICABLE_SELECTOR;
    private final String key;
    private final byte id;
    private static final Map<String, IndexComponentSelector> KEY_REGISTRY;
    private static final Map<Byte, IndexComponentSelector> ID_REGISTRY;

    private IndexComponentSelector(String key, byte id) {
        this.key = key;
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public byte getId() {
        return this.id;
    }

    @Nullable
    public static IndexComponentSelector getByKey(String key) {
        return KEY_REGISTRY.get(key);
    }

    public static IndexComponentSelector getByKeyOrThrow(@Nullable String key) {
        if (key == null) {
            return DATA;
        }
        IndexComponentSelector selector = IndexComponentSelector.getByKey(key);
        if (selector == null) {
            throw new InvalidSelectorException("Unknown key of index component selector [" + key + "], available options are: " + String.valueOf(KEY_REGISTRY.keySet()));
        }
        return selector;
    }

    public static IndexComponentSelector read(StreamInput in) throws IOException {
        byte id = in.readByte();
        if (in.getTransportVersion().supports(REMOVE_ALL_APPLICABLE_SELECTOR)) {
            return IndexComponentSelector.getById(id);
        }
        return id == 2 ? DATA : IndexComponentSelector.getById(id);
    }

    static IndexComponentSelector getById(byte id) {
        IndexComponentSelector indexComponentSelector = ID_REGISTRY.get(id);
        if (indexComponentSelector == null) {
            throw new InvalidSelectorException("Unknown id of index component selector [" + id + "], available options are: " + String.valueOf(ID_REGISTRY));
        }
        return indexComponentSelector;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    public boolean shouldIncludeData() {
        return this == DATA;
    }

    public boolean shouldIncludeFailures() {
        return this == FAILURES;
    }

    static {
        REMOVE_ALL_APPLICABLE_SELECTOR = TransportVersion.fromName("remove_all_applicable_selector");
        HashMap<String, IndexComponentSelector> keyRegistry = new HashMap<String, IndexComponentSelector>(IndexComponentSelector.values().length);
        for (IndexComponentSelector value : IndexComponentSelector.values()) {
            keyRegistry.put(value.getKey(), value);
        }
        KEY_REGISTRY = Collections.unmodifiableMap(keyRegistry);
        HashMap<Byte, IndexComponentSelector> idRegistry = new HashMap<Byte, IndexComponentSelector>(IndexComponentSelector.values().length);
        for (IndexComponentSelector value : IndexComponentSelector.values()) {
            idRegistry.put(value.getId(), value);
        }
        ID_REGISTRY = Collections.unmodifiableMap(idRegistry);
    }
}

