/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.shrink.TransportResizeAction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreStats;

public interface ResizeNumberOfShardsCalculator {
    public int calculate(@Nullable Integer var1, @Nullable ByteSizeValue var2, IndexMetadata var3);

    public void validate(int var1, IndexMetadata var2);

    public static class SplitShardsCalculator
    implements ResizeNumberOfShardsCalculator {
        @Override
        public int calculate(Integer numberOfShards, ByteSizeValue maxPrimaryShardSize, IndexMetadata sourceMetadata) {
            assert (numberOfShards != null) : "split must specify the number of shards explicitly";
            return numberOfShards;
        }

        @Override
        public void validate(int numberOfShards, IndexMetadata sourceMetadata) {
            for (int i = 0; i < numberOfShards; ++i) {
                Objects.requireNonNull(IndexMetadata.selectSplitShard(i, sourceMetadata, numberOfShards));
            }
        }
    }

    public static class CloneShardsCalculator
    implements ResizeNumberOfShardsCalculator {
        @Override
        public int calculate(Integer numberOfShards, ByteSizeValue maxPrimaryShardSize, IndexMetadata sourceMetadata) {
            return numberOfShards != null ? numberOfShards.intValue() : sourceMetadata.getNumberOfShards();
        }

        @Override
        public void validate(int numberOfShards, IndexMetadata sourceMetadata) {
            for (int i = 0; i < numberOfShards; ++i) {
                Objects.requireNonNull(IndexMetadata.selectCloneShard(i, sourceMetadata, numberOfShards));
            }
        }
    }

    public static class ShrinkShardsCalculator
    implements ResizeNumberOfShardsCalculator {
        private static final Logger logger = LogManager.getLogger(TransportResizeAction.class);
        private final StoreStats indexStoreStats;
        private final IntFunction<DocsStats> perShardDocStats;

        public ShrinkShardsCalculator(StoreStats indexStoreStats, IntFunction<DocsStats> perShardDocStats) {
            this.indexStoreStats = indexStoreStats;
            this.perShardDocStats = perShardDocStats;
        }

        @Override
        public int calculate(Integer numberOfShards, ByteSizeValue maxPrimaryShardSize, IndexMetadata sourceMetadata) {
            if (numberOfShards != null) {
                if (maxPrimaryShardSize != null) {
                    throw new IllegalArgumentException("Cannot set both index.number_of_shards and max_primary_shard_size for the target index");
                }
                return numberOfShards;
            }
            if (maxPrimaryShardSize != null) {
                long maxPrimaryShardSizeBytes;
                int sourceIndexShardsNum = sourceMetadata.getNumberOfShards();
                long sourceIndexStorageBytes = this.indexStoreStats.sizeInBytes();
                long minShardsNum = sourceIndexStorageBytes / (maxPrimaryShardSizeBytes = maxPrimaryShardSize.getBytes());
                if (minShardsNum * maxPrimaryShardSizeBytes < sourceIndexStorageBytes) {
                    ++minShardsNum;
                }
                if (minShardsNum > (long)sourceIndexShardsNum) {
                    logger.info("By setting max_primary_shard_size to [{}], the shrunk index will contain [{}] shards, which will be greater than [{}] shards in the source index [{}], using [{}] for the shard count of the shrunk index", (Object)maxPrimaryShardSize.toString(), (Object)minShardsNum, (Object)sourceIndexShardsNum, (Object)sourceMetadata.getIndex().getName(), (Object)sourceIndexShardsNum);
                    return sourceIndexShardsNum;
                }
                return ShrinkShardsCalculator.calculateAcceptableNumberOfShards(sourceIndexShardsNum, (int)minShardsNum);
            }
            return 1;
        }

        @Override
        public void validate(int numberOfShards, IndexMetadata sourceMetadata) {
            for (int i = 0; i < numberOfShards; ++i) {
                Set<ShardId> shardIds = IndexMetadata.selectShrinkShards(i, sourceMetadata, numberOfShards);
                long count = 0L;
                for (ShardId shardId : shardIds) {
                    DocsStats docsStats = this.perShardDocStats.apply(shardId.id());
                    if (docsStats != null) {
                        count += docsStats.getCount();
                    }
                    if (count <= 0x7FFFFF7FL) continue;
                    throw new IllegalStateException("Can't merge index with more than [2147483519] docs - too many documents in shards " + String.valueOf(shardIds));
                }
            }
        }

        protected static int calculateAcceptableNumberOfShards(int sourceIndexShardsNum, int minShardsNum) {
            if (sourceIndexShardsNum <= 0 || minShardsNum <= 0) {
                return 1;
            }
            if (sourceIndexShardsNum % minShardsNum == 0) {
                return minShardsNum;
            }
            int num = (int)Math.floor(Math.sqrt(sourceIndexShardsNum));
            if (minShardsNum >= num) {
                for (int i = num; i >= 1; --i) {
                    if (sourceIndexShardsNum % i != 0 || minShardsNum > sourceIndexShardsNum / i) continue;
                    return sourceIndexShardsNum / i;
                }
            } else {
                for (int i = 1; i <= num; ++i) {
                    if (sourceIndexShardsNum % i != 0 || minShardsNum > i) continue;
                    return i;
                }
            }
            return sourceIndexShardsNum;
        }
    }
}

