/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.common.TriConsumer;

public final class MappingVisitor {
    public static final String PROPERTIES = "properties";
    public static final String FIELD_TYPE = "type";
    public static final String MULTI_FIELDS = "fields";

    private MappingVisitor() {
    }

    public static void visitMapping(Map<String, ?> mapping, BiConsumer<String, Map<String, ?>> fieldMappingConsumer) {
        MappingVisitor.visitMapping(mapping, "", fieldMappingConsumer, fieldMappingConsumer);
    }

    public static void visitMapping(Map<String, ?> mapping, BiConsumer<String, Map<String, ?>> fieldMappingConsumer, BiConsumer<String, Map<String, ?>> multiFieldsMappingConsumer) {
        MappingVisitor.visitMapping(mapping, "", fieldMappingConsumer, multiFieldsMappingConsumer);
    }

    private static void visitMapping(Map<String, ?> mapping, String path, BiConsumer<String, Map<String, ?>> propertiesMappingConsumer, BiConsumer<String, Map<String, ?>> multiFieldsMappingConsumer) {
        Object properties = mapping.get(PROPERTIES);
        if (properties instanceof Map) {
            Map propertiesAsMap = (Map)properties;
            for (Map.Entry entry : propertiesAsMap.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof Map)) continue;
                Map fieldMapping = (Map)v;
                String prefix = path + (String)entry.getKey();
                propertiesMappingConsumer.accept(prefix, fieldMapping);
                MappingVisitor.visitMapping(fieldMapping, prefix + ".", propertiesMappingConsumer, multiFieldsMappingConsumer);
                Object fieldsO = fieldMapping.get(MULTI_FIELDS);
                if (!(fieldsO instanceof Map)) continue;
                Map fields = (Map)fieldsO;
                for (Map.Entry subfieldEntry : fields.entrySet()) {
                    Object v2 = subfieldEntry.getValue();
                    if (!(v2 instanceof Map)) continue;
                    Map fieldMapping2 = (Map)v2;
                    multiFieldsMappingConsumer.accept(prefix + "." + (String)subfieldEntry.getKey(), fieldMapping2);
                }
            }
        }
    }

    public static void visitRuntimeMapping(Map<String, ?> mapping, BiConsumer<String, Map<String, ?>> runtimeFieldMappingConsumer) {
        Object runtimeObject = mapping.get("runtime");
        if (!(runtimeObject instanceof Map)) {
            return;
        }
        Map runtimeMappings = (Map)runtimeObject;
        for (Map.Entry entry : runtimeMappings.entrySet()) {
            Object runtimeFieldMappingObject = entry.getValue();
            if (!(runtimeFieldMappingObject instanceof Map)) continue;
            Map runtimeFieldMapping = (Map)runtimeFieldMappingObject;
            runtimeFieldMappingConsumer.accept((String)entry.getKey(), runtimeFieldMapping);
        }
    }

    public static void visitPropertiesAndCopyMapping(Map<String, ?> sourceMapping, Map<String, Object> destMapping, TriConsumer<String, Map<String, ?>, Map<String, Object>> fieldMappingConsumer) {
        Map<String, ?> sourceProperties = MappingVisitor.getMapOrNull(sourceMapping.get(PROPERTIES));
        if (sourceProperties == null) {
            return;
        }
        HashMap<String, Object> destProperties = new HashMap<String, Object>(sourceProperties.size());
        destMapping.put(PROPERTIES, destProperties);
        for (Map.Entry<String, ?> entry : sourceProperties.entrySet()) {
            Map<String, ?> sourceFieldMapping = MappingVisitor.getMapOrNull(entry.getValue());
            if (sourceFieldMapping == null) {
                return;
            }
            Map<String, Object> destFieldMapping = MappingVisitor.processAndCopy(entry.getKey(), sourceFieldMapping, destProperties, fieldMappingConsumer);
            MappingVisitor.visitPropertiesAndCopyMapping(sourceFieldMapping, destFieldMapping, fieldMappingConsumer);
        }
    }

    private static Map<String, ?> getMapOrNull(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return map;
        }
        return null;
    }

    private static Map<String, Object> processAndCopy(String fieldName, Map<String, ?> sourceFieldMapping, Map<String, Object> destParentMap, TriConsumer<String, Map<String, ?>, Map<String, Object>> fieldMappingConsumer) {
        HashMap<String, Object> destFieldMapping = new HashMap<String, Object>(sourceFieldMapping.size());
        destParentMap.put(fieldName, destFieldMapping);
        fieldMappingConsumer.apply(fieldName, sourceFieldMapping, destFieldMapping);
        return destFieldMapping;
    }
}

