/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.capabilities;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodeCapability;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodesCapabilitiesRequest;
import org.elasticsearch.action.admin.cluster.node.capabilities.NodesCapabilitiesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.InfrastructureFeatures;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportNodesCapabilitiesAction
extends TransportNodesAction<NodesCapabilitiesRequest, NodesCapabilitiesResponse, NodeCapabilitiesRequest, NodeCapability, Void> {
    public static final ActionType<NodesCapabilitiesResponse> TYPE = new ActionType("cluster:monitor/nodes/capabilities");
    private final RestController restController;
    private final FeatureService featureService;

    @Inject
    public TransportNodesCapabilitiesAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, RestController restController, FeatureService featureService) {
        super(TYPE.name(), clusterService, transportService, actionFilters, NodeCapabilitiesRequest::new, threadPool.executor("management"));
        this.restController = restController;
        this.featureService = featureService;
    }

    @Override
    protected NodesCapabilitiesResponse newResponse(NodesCapabilitiesRequest request, List<NodeCapability> responses, List<FailedNodeException> failures) {
        return new NodesCapabilitiesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeCapabilitiesRequest newNodeRequest(NodesCapabilitiesRequest request) {
        RestApiVersion restVersion = request.restApiVersion().isPresent() ? request.restApiVersion().get() : (this.featureService.clusterHasFeature(this.clusterService.state(), InfrastructureFeatures.CURRENT_VERSION) ? RestApiVersion.current() : RestApiVersion.previous());
        return new NodeCapabilitiesRequest(request.method(), request.path(), request.parameters(), request.capabilities(), restVersion);
    }

    @Override
    protected NodeCapability newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeCapability(in);
    }

    @Override
    protected NodeCapability nodeOperation(NodeCapabilitiesRequest request, Task task) {
        boolean supported = this.restController.checkSupported(request.method, request.path, request.parameters, request.capabilities, request.restApiVersion);
        return new NodeCapability(supported, this.transportService.getLocalNode());
    }

    public static class NodeCapabilitiesRequest
    extends AbstractTransportRequest {
        private final RestRequest.Method method;
        private final String path;
        private final Set<String> parameters;
        private final Set<String> capabilities;
        private final RestApiVersion restApiVersion;

        public NodeCapabilitiesRequest(StreamInput in) throws IOException {
            super(in);
            this.method = in.readEnum(RestRequest.Method.class);
            this.path = in.readString();
            this.parameters = in.readCollectionAsImmutableSet(StreamInput::readString);
            this.capabilities = in.readCollectionAsImmutableSet(StreamInput::readString);
            this.restApiVersion = RestApiVersion.forMajor((int)in.readVInt());
        }

        public NodeCapabilitiesRequest(RestRequest.Method method, String path, Set<String> parameters, Set<String> capabilities, RestApiVersion restApiVersion) {
            this.method = method;
            this.path = path;
            this.parameters = Set.copyOf(parameters);
            this.capabilities = Set.copyOf(capabilities);
            this.restApiVersion = restApiVersion;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeEnum(this.method);
            out.writeString(this.path);
            out.writeCollection(this.parameters, StreamOutput::writeString);
            out.writeCollection(this.capabilities, StreamOutput::writeString);
            out.writeVInt(this.restApiVersion.major);
        }
    }
}

