/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.Objects;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.TimeValue;

public abstract class ActionRequestLazyBuilder<Request extends ActionRequest, Response extends ActionResponse>
implements RequestBuilder<Request, Response> {
    protected final ActionType<Response> action;
    protected final ElasticsearchClient client;

    protected ActionRequestLazyBuilder(ElasticsearchClient client, ActionType<Response> action) {
        Objects.requireNonNull(action, "action must not be null");
        this.action = action;
        this.client = client;
    }

    @Override
    public abstract Request request();

    @Override
    public ActionFuture<Response> execute() {
        return this.client.execute(this.action, this.request());
    }

    @Override
    public Response get() {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    @Override
    public Response get(TimeValue timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    @Override
    public void execute(ActionListener<Response> listener) {
        this.client.execute(this.action, this.request(), listener);
    }
}

