/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.utils;

import java.util.Locale;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;

public final class LicenseUtils {
    public static final LicensedFeature.Momentary PLATINUM_LICENSED_FEATURE = LicensedFeature.momentary(null, (String)"enterprise_search", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary ENTERPRISE_LICENSED_FEATURE = LicensedFeature.momentary(null, (String)"enterprise_search", (License.OperationMode)License.OperationMode.ENTERPRISE);

    public static boolean supportedLicense(Product product, XPackLicenseState licenseState) {
        return product.getLicensedFeature().check(licenseState);
    }

    public static ElasticsearchSecurityException newComplianceException(XPackLicenseState licenseState, Product product) {
        String licenseStatus = licenseState.statusDescription();
        String requiredLicenseStatus = product.requiredLicense.toString().toLowerCase(Locale.ROOT);
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("Current license is non-compliant for " + product.getName() + ". Current license is {}. This feature requires an active trial, {}, or higher license.", RestStatus.FORBIDDEN, new Object[]{licenseStatus, requiredLicenseStatus});
        return e;
    }

    public static enum Product {
        SEARCH_APPLICATION("search application", License.OperationMode.PLATINUM),
        BEHAVIORAL_ANALYTICS("behavioral analytics", License.OperationMode.PLATINUM),
        QUERY_RULES("query rules", License.OperationMode.ENTERPRISE);

        private final String name;
        private final License.OperationMode requiredLicense;

        private Product(String name, License.OperationMode requiredLicense) {
            this.name = name;
            this.requiredLicense = requiredLicense;
        }

        public String getName() {
            return this.name;
        }

        public LicensedFeature.Momentary getLicensedFeature() {
            return switch (this.requiredLicense) {
                case License.OperationMode.PLATINUM -> PLATINUM_LICENSED_FEATURE;
                case License.OperationMode.ENTERPRISE -> ENTERPRISE_LICENSED_FEATURE;
                default -> throw new IllegalStateException("Unknown license operation mode: " + String.valueOf(this.requiredLicense));
            };
        }
    }
}

