/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.search.action.PutSearchApplicationAction;
import org.elasticsearch.xpack.application.utils.LicenseUtils;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutSearchApplicationAction
extends EnterpriseSearchBaseRestHandler {
    public RestPutSearchApplicationAction(XPackLicenseState licenseState) {
        super(licenseState, LicenseUtils.Product.SEARCH_APPLICATION);
    }

    public String getName() {
        return "search_application_put_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_application/search_application/{name}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        PutSearchApplicationAction.Request request = new PutSearchApplicationAction.Request(restRequest.param("name"), restRequest.paramAsBoolean("create", false), (BytesReference)restRequest.content(), restRequest.getXContentType());
        return channel -> client.execute(PutSearchApplicationAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel, PutSearchApplicationAction.Response::status, r -> null));
    }
}

