/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;

public class EsqlListQueriesResponse
extends ActionResponse
implements ToXContentObject {
    private final List<Query> queries;

    public EsqlListQueriesResponse(List<Query> queries) {
        this.queries = queries;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new AssertionError((Object)"should not reach here");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("queries");
        for (Query query : this.queries) {
            query.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public record Query(AsyncExecutionId id, long startTimeMillis, long runningTimeNanos, String query) implements ToXContentFragment
    {
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.id.getEncoded());
            builder.field("start_time_millis", this.startTimeMillis);
            builder.field("running_time_nanos", this.runningTimeNanos);
            builder.field("query", this.query);
            builder.endObject();
            return builder;
        }
    }
}

