/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.local;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.xpack.esql.plan.logical.local.ImmediateLocalSupplier;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class CopyingLocalSupplier
implements LocalSupplier {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LocalSupplier.class, "CopyingSupplier", CopyingLocalSupplier::new);
    private final ImmediateLocalSupplier delegate;

    public CopyingLocalSupplier(Block[] blocks) {
        this.delegate = new ImmediateLocalSupplier(blocks);
    }

    public CopyingLocalSupplier(StreamInput in) throws IOException {
        this.delegate = new ImmediateLocalSupplier(in);
    }

    @Override
    public Block[] get() {
        Block[] blockCopies = new Block[this.delegate.blocks.length];
        for (int i = 0; i < blockCopies.length; ++i) {
            blockCopies[i] = this.delegate.blocks[i].deepCopy(PlannerUtils.NON_BREAKING_BLOCK_FACTORY);
        }
        return blockCopies;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.delegate.writeTo(out);
    }

    public String getWriteableName() {
        return CopyingLocalSupplier.ENTRY.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CopyingLocalSupplier other = (CopyingLocalSupplier)obj;
        return Arrays.equals(this.delegate.blocks, other.delegate.blocks);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

