/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public abstract class UnaryPlan
extends LogicalPlan {
    private final LogicalPlan child;
    private AttributeSet lazyOutputSet;

    protected UnaryPlan(Source source, LogicalPlan child) {
        super(source, Collections.singletonList(child));
        this.child = child;
    }

    public final UnaryPlan replaceChildren(List<LogicalPlan> newChildren) {
        return this.replaceChild(newChildren.get(0));
    }

    public abstract UnaryPlan replaceChild(LogicalPlan var1);

    public LogicalPlan child() {
        return this.child;
    }

    @Override
    public List<Attribute> output() {
        return this.child.output();
    }

    @Override
    public AttributeSet outputSet() {
        if (this.lazyOutputSet == null) {
            List<Attribute> output = this.output();
            this.lazyOutputSet = output == this.child.output() ? this.child.outputSet() : AttributeSet.of(output);
        }
        return this.lazyOutputSet;
    }

    @Override
    public AttributeSet inputSet() {
        return this.child.outputSet();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object)this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UnaryPlan other = (UnaryPlan)((Object)obj);
        return Objects.equals((Object)this.child, (Object)other.child);
    }
}

