/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.type.PotentiallyUnmappedKeywordEsField;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.Rule;

public class PropgateUnmappedFields
extends Rule<LogicalPlan, LogicalPlan> {
    @Override
    public LogicalPlan apply(LogicalPlan logicalPlan) {
        if (logicalPlan instanceof EsRelation) {
            return logicalPlan;
        }
        AttributeSet.Builder unmappedFieldsBuilder = AttributeSet.builder();
        logicalPlan.forEachExpressionDown(FieldAttribute.class, fa -> {
            if (fa.field() instanceof PotentiallyUnmappedKeywordEsField) {
                unmappedFieldsBuilder.add((Attribute)fa);
            }
        });
        AttributeSet unmappedFields = unmappedFieldsBuilder.build();
        return unmappedFields.isEmpty() ? logicalPlan : (LogicalPlan)logicalPlan.transformUp(EsRelation.class, er -> er.withAttributes(NamedExpressions.mergeOutputAttributes(new ArrayList(unmappedFields), er.output())));
    }
}

