/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.ExpressionQueryBuilder;

public class ExpressionQuery
extends Query {
    private final String targetFieldName;
    private final Expression expression;

    public ExpressionQuery(Source source, String targetFieldName, Expression expression) {
        super(source);
        this.targetFieldName = targetFieldName;
        this.expression = expression;
    }

    public String field() {
        return this.targetFieldName;
    }

    protected QueryBuilder asBuilder() {
        return new ExpressionQueryBuilder(this.targetFieldName, this.expression);
    }

    public int hashCode() {
        return Objects.hash(this.targetFieldName, this.expression);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ExpressionQuery other = (ExpressionQuery)((Object)obj);
        return Objects.equals(this.targetFieldName, other.targetFieldName) && Objects.equals(this.expression, other.expression);
    }

    protected String innerToString() {
        return "ExpressionQuery{field='" + this.targetFieldName + "'}";
    }

    public boolean containsPlan() {
        return true;
    }
}

