/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.rerank;

import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.esql.inference.InferenceOperator;

class RerankOperatorOutputBuilder
implements InferenceOperator.OutputBuilder {
    private final Page inputPage;
    private final DoubleBlock.Builder scoreBlockBuilder;
    private final int scoreChannel;

    RerankOperatorOutputBuilder(DoubleBlock.Builder scoreBlockBuilder, Page inputPage, int scoreChannel) {
        this.inputPage = inputPage;
        this.scoreBlockBuilder = scoreBlockBuilder;
        this.scoreChannel = scoreChannel;
    }

    public void close() {
        Releasables.close((Releasable)this.scoreBlockBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page buildOutput() {
        Page outputPage = this.inputPage.appendBlock((Block)this.scoreBlockBuilder.build());
        if (this.scoreChannel == this.inputPage.getBlockCount()) {
            return outputPage;
        }
        try {
            int[] blockNapping = IntStream.range(0, this.inputPage.getBlockCount()).map(channel -> channel == this.scoreChannel ? this.inputPage.getBlockCount() : channel).toArray();
            Page page = outputPage.projectBlocks(blockNapping);
            return page;
        }
        finally {
            this.releasePageOnAnyThread(outputPage);
        }
    }

    @Override
    public void addInferenceResponse(InferenceAction.Response inferenceResponse) {
        if (inferenceResponse == null) {
            this.scoreBlockBuilder.appendNull();
            return;
        }
        Iterator sortedRankedDocIterator = this.inferenceResults(inferenceResponse).getRankedDocs().stream().sorted(Comparator.comparingInt(RankedDocsResults.RankedDoc::index)).iterator();
        while (sortedRankedDocIterator.hasNext()) {
            this.scoreBlockBuilder.appendDouble((double)((RankedDocsResults.RankedDoc)sortedRankedDocIterator.next()).relevanceScore());
        }
    }

    private RankedDocsResults inferenceResults(InferenceAction.Response inferenceResponse) {
        return InferenceOperator.OutputBuilder.inferenceResults(inferenceResponse, RankedDocsResults.class);
    }
}

