/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.vector;

import java.io.IOException;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.vector.VectorSimilarityFunction;

public class Hamming
extends VectorSimilarityFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Hamming", Hamming::new);
    static final VectorSimilarityFunction.SimilarityEvaluatorFunction SIMILARITY_FUNCTION = Hamming::calculateSimilarity;

    @FunctionInfo(returnType={"double"}, preview=true, description="Calculates the Hamming distance between two dense vectors.", examples={@Example(file="vector-hamming", tag="vector-hamming")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")})
    public Hamming(Source source, @Param(name="left", type={"dense_vector"}, description="First dense_vector to use to calculate the Hamming distance") Expression left, @Param(name="right", type={"dense_vector"}, description="Second dense_vector to use to calculate the Hamming distance") Expression right) {
        super(source, left, right);
    }

    private Hamming(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected VectorSimilarityFunction.SimilarityEvaluatorFunction getSimilarityFunction() {
        return SIMILARITY_FUNCTION;
    }

    protected BinaryScalarFunction replaceChildren(Expression newLeft, Expression newRight) {
        return new Hamming(this.source(), newLeft, newRight);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Hamming::new, (Object)this.left(), (Object)this.right());
    }

    public String getWriteableName() {
        return Hamming.ENTRY.name;
    }

    public static float calculateSimilarity(float[] leftScratch, float[] rightScratch) {
        int i;
        byte[] a = new byte[leftScratch.length];
        byte[] b = new byte[rightScratch.length];
        for (i = 0; i < leftScratch.length; ++i) {
            a[i] = (byte)leftScratch[i];
        }
        for (i = 0; i < leftScratch.length; ++i) {
            b[i] = (byte)rightScratch[i];
        }
        return VectorUtil.xorBitCount((byte[])a, (byte[])b);
    }
}

