/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Replace;

public final class ReplaceConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ReplaceConstantEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator str;
    private final Pattern regex;
    private final EvalOperator.ExpressionEvaluator newStr;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ReplaceConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator str, Pattern regex, EvalOperator.ExpressionEvaluator newStr, DriverContext driverContext) {
        this.source = source;
        this.str = str;
        this.regex = regex;
        this.newStr = newStr;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                BytesRefVector newStrVector;
                BytesRefVector strVector;
                BytesRefBlock newStrBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                newStrBlock = (BytesRefBlock)this.newStr.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), strBlock, newStrBlock);
                                    if (newStrBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (newStrBlock != null) {
                                        try {
                                            newStrBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                newStrBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        newStrVector = newStrBlock.asVector();
                        if (newStrVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), strBlock, newStrBlock);
                        if (newStrBlock == null) break block19;
                        newStrBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), strVector, newStrVector);
                if (newStrBlock == null) break block20;
                newStrBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.str.baseRamBytesUsed();
        return baseRamBytesUsed += this.newStr.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock newStrBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef newStrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (newStrBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (newStrBlock.getValueCount(p) != 1) {
                    if (newStrBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                BytesRef str = strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch);
                BytesRef newStr = newStrBlock.getBytesRef(newStrBlock.getFirstValueIndex(p), newStrScratch);
                try {
                    result.appendBytesRef(Replace.process(str, this.regex, newStr));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector strVector, BytesRefVector newStrVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef newStrScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef str = strVector.getBytesRef(p, strScratch);
                BytesRef newStr = newStrVector.getBytesRef(p, newStrScratch);
                try {
                    result.appendBytesRef(Replace.process(str, this.regex, newStr));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "ReplaceConstantEvaluator[str=" + String.valueOf(this.str) + ", regex=" + String.valueOf(this.regex) + ", newStr=" + String.valueOf(this.newStr) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.newStr});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final Pattern regex;
        private final EvalOperator.ExpressionEvaluator.Factory newStr;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, Pattern regex, EvalOperator.ExpressionEvaluator.Factory newStr) {
            this.source = source;
            this.str = str;
            this.regex = regex;
            this.newStr = newStr;
        }

        public ReplaceConstantEvaluator get(DriverContext context) {
            return new ReplaceConstantEvaluator(this.source, this.str.get(context), this.regex, this.newStr.get(context), context);
        }

        public String toString() {
            return "ReplaceConstantEvaluator[str=" + String.valueOf(this.str) + ", regex=" + String.valueOf(this.regex) + ", newStr=" + String.valueOf(this.newStr) + "]";
        }
    }
}

