/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContains;

public final class SpatialContainsGeoPointDocValuesAndConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SpatialContainsGeoPointDocValuesAndConstantEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator left;
    private final Component2D[] right;
    private final DriverContext driverContext;
    private Warnings warnings;

    public SpatialContainsGeoPointDocValuesAndConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator left, Component2D[] right, DriverContext driverContext) {
        this.source = source;
        this.left = left;
        this.right = right;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock leftBlock = (LongBlock)this.left.eval(page);){
            BooleanBlock booleanBlock = this.eval(page.getPositionCount(), leftBlock);
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.left.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, LongBlock leftBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!leftBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    SpatialContains.processGeoPointDocValuesAndConstant(result, p, leftBlock, this.right);
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.warnings().registerException(e);
                    result.appendNull();
                }
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "SpatialContainsGeoPointDocValuesAndConstantEvaluator[left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.left);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory left;
        private final Component2D[] right;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory left, Component2D[] right) {
            this.source = source;
            this.left = left;
            this.right = right;
        }

        public SpatialContainsGeoPointDocValuesAndConstantEvaluator get(DriverContext context) {
            return new SpatialContainsGeoPointDocValuesAndConstantEvaluator(this.source, this.left.get(context), this.right, context);
        }

        public String toString() {
            return "SpatialContainsGeoPointDocValuesAndConstantEvaluator[left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "]";
        }
    }
}

