/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.score;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.Decay;

public final class DecayIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DecayIntEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator value;
    private final int origin;
    private final int scale;
    private final int offset;
    private final double decay;
    private final Decay.DecayFunction decayFunction;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DecayIntEvaluator(Source source, EvalOperator.ExpressionEvaluator value, int origin, int scale, int offset, double decay, Decay.DecayFunction decayFunction, DriverContext driverContext) {
        this.source = source;
        this.value = value;
        this.origin = origin;
        this.scale = scale;
        this.offset = offset;
        this.decay = decay;
        this.decayFunction = decayFunction;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock valueBlock = (IntBlock)this.value.eval(page);){
            IntVector valueVector = valueBlock.asVector();
            if (valueVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valueBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valueVector).asBlock();
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.value.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, IntBlock valueBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valueBlock.getValueCount(p) != 1) {
                    if (valueBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                int value = valueBlock.getInt(valueBlock.getFirstValueIndex(p));
                result.appendDouble(Decay.process(value, this.origin, this.scale, this.offset, this.decay, this.decayFunction));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, IntVector valueVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int value = valueVector.getInt(p);
                result.appendDouble(p, Decay.process(value, this.origin, this.scale, this.offset, this.decay, this.decayFunction));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "DecayIntEvaluator[value=" + String.valueOf(this.value) + ", origin=" + this.origin + ", scale=" + this.scale + ", offset=" + this.offset + ", decay=" + this.decay + ", decayFunction=" + String.valueOf((Object)this.decayFunction) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.value);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory value;
        private final int origin;
        private final int scale;
        private final int offset;
        private final double decay;
        private final Decay.DecayFunction decayFunction;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory value, int origin, int scale, int offset, double decay, Decay.DecayFunction decayFunction) {
            this.source = source;
            this.value = value;
            this.origin = origin;
            this.scale = scale;
            this.offset = offset;
            this.decay = decay;
            this.decayFunction = decayFunction;
        }

        public DecayIntEvaluator get(DriverContext context) {
            return new DecayIntEvaluator(this.source, this.value.get(context), this.origin, this.scale, this.offset, this.decay, this.decayFunction, context);
        }

        public String toString() {
            return "DecayIntEvaluator[value=" + String.valueOf(this.value) + ", origin=" + this.origin + ", scale=" + this.scale + ", offset=" + this.offset + ", decay=" + this.decay + ", decayFunction=" + String.valueOf((Object)this.decayFunction) + "]";
        }
    }
}

