/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DayNameMillisEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DayNameNanosEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.session.Configuration;

public class DayName
extends EsqlConfigurationFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DayName", DayName::new);
    private final Expression field;

    @FunctionInfo(returnType={"keyword"}, description="Returns the name of the weekday for date based on the configured Locale.", examples={@Example(file="date", tag="docsDayName")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.2.0")})
    public DayName(Source source, @Param(name="date", type={"date", "date_nanos"}, description="Date expression. If `null`, the function returns `null`.") Expression date, Configuration configuration) {
        super(source, List.of(date), configuration);
        this.field = date;
    }

    private DayName(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), ((PlanStreamInput)in).configuration());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
    }

    public String getWriteableName() {
        return DayName.ENTRY.name;
    }

    Expression field() {
        return this.field;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        String operationName = this.sourceText();
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)this.field, DataType::isDate, (String)operationName, (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"datetime or date_nanos"});
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public boolean foldable() {
        return this.field.foldable();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        if (this.field().dataType() == DataType.DATE_NANOS) {
            return new DayNameNanosEvaluator.Factory(this.source(), fieldEvaluator, this.configuration().zoneId(), this.configuration().locale());
        }
        return new DayNameMillisEvaluator.Factory(this.source(), fieldEvaluator, this.configuration().zoneId(), this.configuration().locale());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DayName(this.source(), newChildren.get(0), this.configuration());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DayName::new, (Object)this.field, (Object)this.configuration());
    }

    static BytesRef processMillis(long val, ZoneId zoneId, Locale locale) {
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(val), zoneId);
        String displayName = dateTime.getDayOfWeek().getDisplayName(TextStyle.FULL, locale);
        return new BytesRef((CharSequence)displayName);
    }

    static BytesRef processNanos(long val, ZoneId zoneId, Locale locale) {
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(0L, val), zoneId);
        String displayName = dateTime.getDayOfWeek().getDisplayName(TextStyle.FULL, locale);
        return new BytesRef((CharSequence)displayName);
    }
}

