/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtract;

public final class DateExtractMillisEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DateExtractMillisEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator value;
    private final EvalOperator.ExpressionEvaluator chronoField;
    private final ZoneId zone;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DateExtractMillisEvaluator(Source source, EvalOperator.ExpressionEvaluator value, EvalOperator.ExpressionEvaluator chronoField, ZoneId zone, DriverContext driverContext) {
        this.source = source;
        this.value = value;
        this.chronoField = chronoField;
        this.zone = zone;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock valueBlock = (LongBlock)this.value.eval(page);){
            LongBlock longBlock;
            block20: {
                BytesRefVector chronoFieldVector;
                LongVector valueVector;
                BytesRefBlock chronoFieldBlock;
                block18: {
                    LongBlock longBlock2;
                    block19: {
                        block16: {
                            LongBlock longBlock3;
                            block17: {
                                chronoFieldBlock = (BytesRefBlock)this.chronoField.eval(page);
                                try {
                                    valueVector = valueBlock.asVector();
                                    if (valueVector != null) break block16;
                                    longBlock3 = this.eval(page.getPositionCount(), valueBlock, chronoFieldBlock);
                                    if (chronoFieldBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (chronoFieldBlock != null) {
                                        try {
                                            chronoFieldBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                chronoFieldBlock.close();
                            }
                            return longBlock3;
                        }
                        chronoFieldVector = chronoFieldBlock.asVector();
                        if (chronoFieldVector != null) break block18;
                        longBlock2 = this.eval(page.getPositionCount(), valueBlock, chronoFieldBlock);
                        if (chronoFieldBlock == null) break block19;
                        chronoFieldBlock.close();
                    }
                    return longBlock2;
                }
                longBlock = this.eval(page.getPositionCount(), valueVector, chronoFieldVector);
                if (chronoFieldBlock == null) break block20;
                chronoFieldBlock.close();
            }
            return longBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.value.baseRamBytesUsed();
        return baseRamBytesUsed += this.chronoField.baseRamBytesUsed();
    }

    public LongBlock eval(int positionCount, LongBlock valueBlock, BytesRefBlock chronoFieldBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef chronoFieldScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (valueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valueBlock.getValueCount(p) != 1) {
                    if (valueBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (chronoFieldBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (chronoFieldBlock.getValueCount(p) != 1) {
                    if (chronoFieldBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                long value = valueBlock.getLong(valueBlock.getFirstValueIndex(p));
                BytesRef chronoField = chronoFieldBlock.getBytesRef(chronoFieldBlock.getFirstValueIndex(p), chronoFieldScratch);
                try {
                    result.appendLong(DateExtract.processMillis(value, chronoField, this.zone));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongVector valueVector, BytesRefVector chronoFieldVector) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef chronoFieldScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                long value = valueVector.getLong(p);
                BytesRef chronoField = chronoFieldVector.getBytesRef(p, chronoFieldScratch);
                try {
                    result.appendLong(DateExtract.processMillis(value, chronoField, this.zone));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "DateExtractMillisEvaluator[value=" + String.valueOf(this.value) + ", chronoField=" + String.valueOf(this.chronoField) + ", zone=" + String.valueOf(this.zone) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.value, this.chronoField});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory value;
        private final EvalOperator.ExpressionEvaluator.Factory chronoField;
        private final ZoneId zone;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory value, EvalOperator.ExpressionEvaluator.Factory chronoField, ZoneId zone) {
            this.source = source;
            this.value = value;
            this.chronoField = chronoField;
            this.zone = zone;
        }

        public DateExtractMillisEvaluator get(DriverContext context) {
            return new DateExtractMillisEvaluator(this.source, this.value.get(context), this.chronoField.get(context), this.zone, context);
        }

        public String toString() {
            return "DateExtractMillisEvaluator[value=" + String.valueOf(this.value) + ", chronoField=" + String.valueOf(this.chronoField) + ", zone=" + String.valueOf(this.zone) + "]";
        }
    }
}

