/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.planner.Layout;

public final class MatchConfig
implements Writeable {
    private final String fieldName;
    private final int channel;
    private final DataType type;

    public MatchConfig(String fieldName, int channel, DataType type) {
        this.fieldName = fieldName;
        this.channel = channel;
        this.type = type;
    }

    public MatchConfig(String fieldName, Layout.ChannelAndType input) {
        this(fieldName, input.channel(), input.type());
    }

    public MatchConfig(StreamInput in) throws IOException {
        this(in.readString(), in.readInt(), DataType.readFrom((StreamInput)in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeInt(this.channel);
        this.type.writeTo(out);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public int channel() {
        return this.channel;
    }

    public DataType type() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MatchConfig that = (MatchConfig)obj;
        return Objects.equals(this.fieldName, that.fieldName) && this.channel == that.channel && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.channel, this.type);
    }

    public String toString() {
        return "MatchConfig[fieldName=" + this.fieldName + ", channel=" + this.channel + ", type=" + String.valueOf(this.type) + "]";
    }
}

