/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.compute.operator.lookup.LookupEnrichQueryGenerator;
import org.elasticsearch.compute.operator.lookup.QueryList;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.xpack.esql.action.EsqlCapabilities;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.enrich.AbstractLookupService;
import org.elasticsearch.xpack.esql.enrich.BinaryComparisonQueryList;
import org.elasticsearch.xpack.esql.enrich.LookupFromIndexService;
import org.elasticsearch.xpack.esql.enrich.MatchConfig;
import org.elasticsearch.xpack.esql.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.plugin.EsqlFlags;
import org.elasticsearch.xpack.esql.stats.SearchContextStats;

public class ExpressionQueryList
implements LookupEnrichQueryGenerator {
    private final List<QueryList> queryLists;
    private final List<Query> preJoinFilters = new ArrayList<Query>();
    private final SearchExecutionContext context;
    private final AliasFilter aliasFilter;

    private ExpressionQueryList(List<QueryList> queryLists, SearchExecutionContext context, PhysicalPlan rightPreJoinPlan, ClusterService clusterService, AliasFilter aliasFilter) {
        this.queryLists = new ArrayList<QueryList>(queryLists);
        this.context = context;
        this.aliasFilter = aliasFilter;
        this.buildPreJoinFilter(rightPreJoinPlan, clusterService);
    }

    public static ExpressionQueryList fieldBasedJoin(List<QueryList> queryLists, SearchExecutionContext context, PhysicalPlan rightPreJoinPlan, ClusterService clusterService, AliasFilter aliasFilter) {
        if (queryLists.size() < 2 && !(rightPreJoinPlan instanceof FilterExec)) {
            throw new IllegalArgumentException("ExpressionQueryList must have at least two QueryLists or a pre-join filter");
        }
        return new ExpressionQueryList(queryLists, context, rightPreJoinPlan, clusterService, aliasFilter);
    }

    public static ExpressionQueryList expressionBasedJoin(SearchExecutionContext context, PhysicalPlan rightPreJoinPlan, ClusterService clusterService, LookupFromIndexService.TransportRequest request, AliasFilter aliasFilter, Warnings warnings) {
        if (!EsqlCapabilities.Cap.LOOKUP_JOIN_ON_BOOLEAN_EXPRESSION.isEnabled()) {
            throw new UnsupportedOperationException("Lookup Join on Boolean Expression capability is not enabled");
        }
        if (request.getJoinOnConditions() == null) {
            throw new IllegalStateException("expressionBasedJoin must have join conditions");
        }
        ExpressionQueryList expressionQueryList = new ExpressionQueryList(new ArrayList<QueryList>(), context, rightPreJoinPlan, clusterService, aliasFilter);
        expressionQueryList.buildJoinOnForExpressionJoin(request.getJoinOnConditions(), request.getMatchFields(), request.getInputPage(), clusterService, warnings);
        return expressionQueryList;
    }

    private void buildJoinOnForExpressionJoin(Expression joinOnConditions, List<MatchConfig> matchFields, Page inputPage, ClusterService clusterService, Warnings warnings) {
        List<Expression> expressions = Predicates.splitAnd(joinOnConditions);
        for (Expression expr : expressions) {
            if (expr instanceof EsqlBinaryComparison) {
                EsqlBinaryComparison binaryComparison = (EsqlBinaryComparison)expr;
                Expression left = binaryComparison.left();
                if (left instanceof Attribute) {
                    Attribute leftAttribute = (Attribute)left;
                    boolean matched = false;
                    for (int i = 0; i < matchFields.size(); ++i) {
                        if (!matchFields.get(i).fieldName().equals(leftAttribute.name())) continue;
                        Block block = inputPage.getBlock(i);
                        Expression right = binaryComparison.right();
                        if (right instanceof Attribute) {
                            Attribute rightAttribute = (Attribute)right;
                            MappedFieldType fieldType = this.context.getFieldType(rightAttribute.name());
                            if (fieldType != null) {
                                if (binaryComparison instanceof Equals) {
                                    QueryList termQueryForEquals = AbstractLookupService.termQueryList(fieldType, this.context, this.aliasFilter, inputPage.getBlock(matchFields.get(i).channel()), matchFields.get(i).type()).onlySingleValues(warnings, "LOOKUP JOIN encountered multi-value");
                                    this.queryLists.add(termQueryForEquals);
                                } else {
                                    this.queryLists.add(new BinaryComparisonQueryList(fieldType, this.context, block, binaryComparison, clusterService, this.aliasFilter, warnings));
                                }
                                matched = true;
                                break;
                            }
                            throw new IllegalStateException("Could not find field [" + rightAttribute.name() + "] in the lookup join index");
                        }
                        throw new IllegalStateException("Only field from the right dataset are supported on the right of the join on condition but got: " + String.valueOf(expr));
                    }
                    if (matched) continue;
                    throw new IllegalStateException("Could not find field [" + leftAttribute.name() + "] in the left side of the lookup join");
                }
                throw new IllegalStateException("Only field from the left dataset are supported on the left of the join on condition but got: " + String.valueOf(expr));
            }
            throw new IllegalStateException("Only binary comparisons are supported in join ON conditions, but got: " + String.valueOf(expr));
        }
    }

    private void addToPreJoinFilters(QueryBuilder query) {
        try {
            if (query != null) {
                this.preJoinFilters.add(query.toQuery(this.context));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while building query for PreJoinFilters filter", e);
        }
    }

    private void buildPreJoinFilter(PhysicalPlan rightPreJoinPlan, ClusterService clusterService) {
        if (rightPreJoinPlan instanceof FilterExec) {
            FilterExec filterExec = (FilterExec)rightPreJoinPlan;
            List<Expression> candidateRightHandFilters = Predicates.splitAnd(filterExec.condition());
            LucenePushdownPredicates lucenePushdownPredicates = LucenePushdownPredicates.from(SearchContextStats.from(List.of(this.context)), new EsqlFlags(clusterService.getClusterSettings()));
            for (Expression filter : candidateRightHandFilters) {
                TranslationAware translationAware;
                if (!(filter instanceof TranslationAware) || !TranslationAware.Translatable.YES.equals((Object)(translationAware = (TranslationAware)filter).translatable(lucenePushdownPredicates))) continue;
                this.addToPreJoinFilters(translationAware.asQuery(lucenePushdownPredicates, TranslatorHandler.TRANSLATOR_HANDLER).toQueryBuilder());
            }
        } else if (rightPreJoinPlan != null && !(rightPreJoinPlan instanceof EsSourceExec)) {
            throw new IllegalStateException("The right side of a LookupJoinExec can only be a FilterExec on top of an EsSourceExec or an EsSourceExec, but got: " + String.valueOf((Object)rightPreJoinPlan));
        }
    }

    public Query getQuery(int position) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (QueryList queryList : this.queryLists) {
            Query q = queryList.getQuery(position);
            if (q == null) {
                return null;
            }
            builder.add(q, BooleanClause.Occur.FILTER);
        }
        for (Query preJoinFilter : this.preJoinFilters) {
            builder.add(preJoinFilter, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    public int getPositionCount() {
        int positionCount = this.queryLists.get(0).getPositionCount();
        for (QueryList queryList : this.queryLists) {
            if (queryList.getPositionCount() == positionCount) continue;
            throw new IllegalArgumentException("All QueryLists must have the same position count, expected: " + positionCount + ", but got: " + queryList.getPositionCount());
        }
        return positionCount;
    }
}

