/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextFieldMapper;

public class PatternTextBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final PatternTextFieldMapper.DocValuesSupplier docValuesSupplier;

    PatternTextBlockLoader(PatternTextFieldMapper.DocValuesSupplier docValuesSupplier) {
        this.docValuesSupplier = docValuesSupplier;
    }

    public BlockLoader.BytesRefBuilder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.bytesRefs(expectedCount);
    }

    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        BinaryDocValues docValues = this.docValuesSupplier.get(context.reader());
        if (docValues == null) {
            return new BlockLoader.ConstantNullsReader();
        }
        return new BlockDocValuesReader.BytesRefsFromBinary(docValues);
    }
}

