/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextValueProcessor;

public class Arg {
    private static final String SPACE = " ";
    private static final Base64.Decoder DECODER = Base64.getUrlDecoder();
    private static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static int VINT_MAX_BYTES = 5;

    static boolean isArg(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isDigit(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static String encodeInfo(List<Info> arguments) throws IOException {
        int maxSize = VINT_MAX_BYTES + arguments.size() * (VINT_MAX_BYTES + VINT_MAX_BYTES);
        byte[] buffer = new byte[maxSize];
        ByteArrayDataOutput dataInput = new ByteArrayDataOutput(buffer);
        dataInput.writeVInt(arguments.size());
        int previousOffset = 0;
        for (Info arg : arguments) {
            arg.writeTo(dataInput, previousOffset);
            previousOffset = arg.offsetInTemplate;
        }
        int size = dataInput.getPosition();
        byte[] data = Arrays.copyOfRange(buffer, 0, size);
        return ENCODER.encodeToString(data);
    }

    static List<Info> decodeInfo(String encoded) throws IOException {
        byte[] encodedBytes = DECODER.decode(encoded);
        ByteArrayDataInput input = new ByteArrayDataInput(encodedBytes);
        int numArgs = input.readVInt();
        int previousOffset = 0;
        ArrayList<Info> arguments = new ArrayList<Info>(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            Info argInfo = Info.readFrom((DataInput)input, previousOffset);
            arguments.add(argInfo);
            previousOffset = argInfo.offsetInTemplate;
        }
        return arguments;
    }

    static String encodeRemainingArgs(PatternTextValueProcessor.Parts parts) {
        return String.join((CharSequence)SPACE, parts.args());
    }

    static String[] decodeRemainingArgs(String mergedArgs) {
        return mergedArgs.split(SPACE);
    }

    record Info(Type type, int offsetInTemplate) {
        public Info {
            assert (offsetInTemplate >= 0);
        }

        void writeTo(ByteArrayDataOutput out, int previousOffset) throws IOException {
            out.writeVInt(this.type.toCode());
            int diff = this.offsetInTemplate - previousOffset;
            out.writeVInt(diff);
        }

        static Info readFrom(DataInput in, int previousOffset) throws IOException {
            Type type = Type.fromCode(in.readVInt());
            int diffFromPrevious = in.readVInt();
            int offsetInfoTemplate = previousOffset + diffFromPrevious;
            return new Info(type, offsetInfoTemplate);
        }
    }

    public static enum Type {
        GENERIC(0);

        private final int code;
        private static final Type[] lookup;

        private Type(int code) {
            this.code = code;
        }

        public int toCode() {
            return this.code;
        }

        public static Type fromCode(int code) {
            return lookup[code];
        }

        static {
            lookup = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.lookup[type.code] = type = typeArray[i];
            }
        }
    }
}

