/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.logging.Level;
import org.elasticsearch.logging.internal.spi.LoggerFactory;

public abstract class Command
implements Closeable {
    protected final String description;
    protected final OptionParser parser = new OptionParser();
    private final OptionSpec<Void> helpOption = this.parser.acceptsAll(Arrays.asList("h", "help"), "Show help").forHelp();
    private final OptionSpec<Void> silentOption = this.parser.acceptsAll(Arrays.asList("s", "silent"), "Show minimal output");
    private final OptionSpec<Void> verboseOption = this.parser.acceptsAll(Arrays.asList("v", "verbose"), "Show verbose output").availableUnless(this.silentOption, new OptionSpec[0]);

    public Command(String description) {
        this.description = description;
    }

    public final int main(String[] args, Terminal terminal, ProcessInfo processInfo) throws IOException {
        try {
            this.mainWithoutErrorHandling(args, terminal, processInfo);
        }
        catch (OptionException e) {
            this.printHelp(terminal, true);
            terminal.errorPrintln(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage());
            return 64;
        }
        catch (UserException e) {
            if (e.exitCode == 64) {
                this.printHelp(terminal, true);
            }
            this.printUserException(terminal, e);
            return e.exitCode;
        }
        catch (IOException ioe) {
            terminal.errorPrintln(ioe);
            return 74;
        }
        catch (Throwable t) {
            terminal.errorPrintln(t);
            return 70;
        }
        return 0;
    }

    protected void mainWithoutErrorHandling(String[] args, Terminal terminal, ProcessInfo processInfo) throws Exception {
        OptionSet options = this.parseOptions(args);
        if (options.has(this.helpOption)) {
            this.printHelp(terminal, false);
            return;
        }
        LoggerFactory loggerFactory = LoggerFactory.provider();
        if (options.has(this.silentOption)) {
            terminal.setVerbosity(Terminal.Verbosity.SILENT);
            loggerFactory.setRootLevel(Level.OFF);
        } else if (options.has(this.verboseOption)) {
            terminal.setVerbosity(Terminal.Verbosity.VERBOSE);
            loggerFactory.setRootLevel(Level.DEBUG);
        } else {
            terminal.setVerbosity(Terminal.Verbosity.NORMAL);
            loggerFactory.setRootLevel(Level.INFO);
        }
        this.execute(terminal, options, processInfo);
    }

    public OptionSet parseOptions(String[] args) {
        return this.parser.parse(args);
    }

    private void printHelp(Terminal terminal, boolean toStdError) throws IOException {
        StringWriter writer = new StringWriter();
        this.parser.printHelpOn(writer);
        if (toStdError) {
            terminal.errorPrintln(this.description);
            terminal.errorPrintln("");
            terminal.errorPrintln(writer.toString());
        } else {
            terminal.println(this.description);
            terminal.println("");
            this.printAdditionalHelp(terminal);
            terminal.println(writer.toString());
        }
    }

    protected void printAdditionalHelp(Terminal terminal) {
    }

    protected void printUserException(Terminal terminal, UserException e) {
        if (e.getMessage() != null) {
            terminal.errorPrintln("");
            terminal.errorPrintln(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage() + ", with exit code " + e.exitCode);
        }
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    protected static void exit(int status) {
        System.exit(status);
    }

    protected abstract void execute(Terminal var1, OptionSet var2, ProcessInfo var3) throws Exception;

    @Override
    public void close() throws IOException {
    }
}

