/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.rest;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamAction;

public class RestMigrationReindexAction
extends BaseRestHandler {
    public static final String MIGRATION_REINDEX_CAPABILITY = "migration_reindex";

    public String getName() {
        return MIGRATION_REINDEX_CAPABILITY;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_migration/reindex"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ReindexDataStreamAction.ReindexDataStreamRequest reindexRequest;
        try (XContentParser parser = request.contentParser();){
            reindexRequest = ReindexDataStreamAction.ReindexDataStreamRequest.fromXContent(parser);
        }
        return channel -> client.execute((ActionType)ReindexDataStreamAction.INSTANCE, (ActionRequest)reindexRequest, (ActionListener)new ReindexDataStreamRestToXContentListener((RestChannel)channel));
    }

    public Set<String> supportedCapabilities() {
        return Set.of(MIGRATION_REINDEX_CAPABILITY);
    }

    static class ReindexDataStreamRestToXContentListener
    extends RestBuilderListener<AcknowledgedResponse> {
        ReindexDataStreamRestToXContentListener(RestChannel channel) {
            super(channel);
        }

        public RestResponse buildResponse(AcknowledgedResponse response, XContentBuilder builder) throws Exception {
            response.toXContent(builder, (ToXContent.Params)this.channel.request());
            return new RestResponse(RestStatus.OK, builder);
        }
    }
}

