/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.task;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.system_indices.task.SystemResourceMigrationInfo;

final class SystemIndexMigrationInfo
extends SystemResourceMigrationInfo {
    private static final Logger logger = LogManager.getLogger(SystemIndexMigrationInfo.class);
    private final IndexMetadata currentIndex;
    private final String featureName;
    private final Settings settings;
    private final String mapping;
    private final String origin;
    private final String migrationScript;
    private final SystemIndices.Feature owningFeature;
    private final boolean allowsTemplates;

    private SystemIndexMigrationInfo(IndexMetadata currentIndex, String featureName, Settings settings, String mapping, String origin, String migrationScript, SystemIndices.Feature owningFeature, boolean allowsTemplates) {
        super(featureName, origin, owningFeature);
        this.currentIndex = currentIndex;
        this.featureName = featureName;
        this.settings = settings;
        this.mapping = mapping;
        this.origin = origin;
        this.migrationScript = migrationScript;
        this.owningFeature = owningFeature;
        this.allowsTemplates = allowsTemplates;
    }

    String getCurrentIndexName() {
        return this.currentIndex.getIndex().getName();
    }

    @Override
    protected String getCurrentResourceName() {
        return this.getCurrentIndexName();
    }

    @Override
    Stream<IndexMetadata> getIndices(ProjectMetadata metadata) {
        return Stream.of(this.currentIndex);
    }

    @Override
    boolean isCurrentIndexClosed() {
        return IndexMetadata.State.CLOSE.equals((Object)this.currentIndex.getState());
    }

    String getNextIndexName() {
        return this.currentIndex.getIndex().getName() + SystemIndices.UPGRADED_INDEX_SUFFIX;
    }

    @Override
    String getFeatureName() {
        return this.featureName;
    }

    String getMappings() {
        return this.mapping;
    }

    Settings getSettings() {
        return this.settings;
    }

    @Override
    String getOrigin() {
        return this.origin;
    }

    String getMigrationScript() {
        return this.migrationScript;
    }

    boolean allowsTemplates() {
        return this.allowsTemplates;
    }

    @Override
    void prepareForIndicesMigration(ProjectMetadata project, Client client, ActionListener<Map<String, Object>> listener) {
        this.owningFeature.getPreMigrationFunction().prepareForIndicesMigration(project, client, listener);
    }

    @Override
    void indicesMigrationComplete(Map<String, Object> metadata, Client client, ActionListener<Boolean> listener) {
        this.owningFeature.getPostMigrationFunction().indicesMigrationComplete(metadata, client, listener);
    }

    @Override
    Client createClient(Client baseClient) {
        return new OriginSettingClient(baseClient, this.getOrigin());
    }

    public String toString() {
        return "IndexUpgradeInfo[currentIndex='" + this.currentIndex.getIndex().getName() + "', featureName='" + this.featureName + "', settings=" + String.valueOf(this.settings) + ", mapping='" + this.mapping + "', origin='" + this.origin + "'";
    }

    static SystemIndexMigrationInfo build(IndexMetadata currentIndex, SystemIndexDescriptor descriptor, SystemIndices.Feature feature, IndexScopedSettings indexScopedSettings) {
        String mapping;
        Settings settings;
        if (descriptor.isAutomaticallyManaged()) {
            Settings.Builder settingsBuilder = Settings.builder();
            settingsBuilder.put(descriptor.getSettings());
            settingsBuilder.remove("index.version.created");
            settings = settingsBuilder.build();
            mapping = descriptor.getMappings();
        } else {
            settings = SystemIndexMigrationInfo.copySettingsForNewIndex(currentIndex.getSettings(), indexScopedSettings);
            mapping = currentIndex.mapping().source().string();
        }
        return new SystemIndexMigrationInfo(currentIndex, feature.getName(), settings, mapping, descriptor.getOrigin(), descriptor.getMigrationScript(), feature, descriptor.allowsTemplates());
    }

    private static Settings copySettingsForNewIndex(Settings currentIndexSettings, IndexScopedSettings indexScopedSettings) {
        Settings.Builder newIndexSettings = Settings.builder();
        currentIndexSettings.keySet().stream().filter(settingKey -> !indexScopedSettings.isPrivateSetting(settingKey)).map(arg_0 -> ((IndexScopedSettings)indexScopedSettings).get(arg_0)).filter(Objects::nonNull).filter(setting -> !setting.getProperties().contains(Setting.Property.NotCopyableOnResize)).filter(setting -> !setting.getProperties().contains(Setting.Property.PrivateIndex)).forEach(setting -> newIndexSettings.put(setting.getKey(), currentIndexSettings.get(setting.getKey())));
        return newIndexSettings.build();
    }
}

