/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.sql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.sql.plan.physical.FilterExec;
import org.elasticsearch.xpack.sql.plan.physical.LimitExec;
import org.elasticsearch.xpack.sql.plan.physical.OrderExec;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.PivotExec;
import org.elasticsearch.xpack.sql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.sql.plan.physical.UnplannedExec;

abstract class Verifier {
    Verifier() {
    }

    static List<Failure> verifyMappingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof UnplannedExec) {
                failures.add(Failure.fail((Node)p, (String)"Unplanned item", (Object[])new Object[0]));
            }
            p.forEachExpressionUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Failure.fail((Node)e, (String)"Unresolved expression", (Object[])new Object[0]));
                }
            });
        });
        Verifier.checkForNonCollapsableSubselects(plan, failures);
        return failures;
    }

    static List<Failure> verifyExecutingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof Unexecutable) {
                failures.add(Failure.fail((Node)p, (String)"Unexecutable item", (Object[])new Object[0]));
            }
            p.forEachExpressionUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Failure.fail((Node)e, (String)"Unresolved expression", (Object[])new Object[0]));
                }
            });
        });
        return failures;
    }

    private static void checkForNonCollapsableSubselects(PhysicalPlan plan, List<Failure> failures) {
        Holder limit = new Holder();
        Holder limitedExec = new Holder();
        plan.forEachUp(p -> {
            if (limit.get() == null && p instanceof LimitExec) {
                limit.set((Object)((LimitExec)p));
            } else if (limit.get() != null && limitedExec.get() == null && (p instanceof OrderExec || p instanceof FilterExec || p instanceof PivotExec || p instanceof AggregateExec)) {
                limitedExec.set((Object)((UnaryExec)p));
            }
        });
        if (limitedExec.get() != null) {
            failures.add(Failure.fail((Node)((Node)limit.get()), (String)"LIMIT or TOP cannot be used in a subquery if outer query contains GROUP BY, ORDER BY, PIVOT or WHERE", (Object[])new Object[0]));
        }
    }
}

