/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public final class Pivot
extends UnaryPlan {
    private final Expression column;
    private final List<NamedExpression> values;
    private final List<NamedExpression> aggregates;
    private final List<Attribute> grouping;
    private AttributeSet groupingSet;
    private AttributeSet valueOutput;
    private List<Attribute> output;
    private AttributeMap<Expression> aliases;

    public Pivot(Source source, LogicalPlan child, Expression column, List<NamedExpression> values, List<NamedExpression> aggregates) {
        this(source, child, column, values, aggregates, null);
    }

    public Pivot(Source source, LogicalPlan child, Expression column, List<NamedExpression> values, List<NamedExpression> aggregates, List<Attribute> grouping) {
        super(source, child);
        this.column = column;
        this.values = values;
        this.aggregates = aggregates;
        if (grouping == null && this.expressionsResolved()) {
            AttributeSet columnSet = Expressions.references(Collections.singletonList(column));
            grouping = new ArrayList<Attribute>((Collection<Attribute>)new AttributeSet((Collection)Expressions.onlyPrimitiveFieldAttributes((Collection)this.child().output())).subtract(columnSet).subtract(Expressions.references(aggregates)).combine(columnSet));
        }
        this.grouping = grouping;
        this.groupingSet = grouping != null ? new AttributeSet(grouping) : null;
    }

    protected NodeInfo<Pivot> info() {
        return NodeInfo.create((Node)this, Pivot::new, (Object)this.child(), (Object)this.column, this.values, this.aggregates, this.grouping);
    }

    public Pivot replaceChild(LogicalPlan newChild) {
        return new Pivot(this.source(), newChild, this.column, this.values, this.aggregates, this.grouping);
    }

    public Expression column() {
        return this.column;
    }

    public List<NamedExpression> values() {
        return this.values;
    }

    public List<NamedExpression> aggregates() {
        return this.aggregates;
    }

    public List<Attribute> groupings() {
        return this.grouping;
    }

    public AttributeSet groupingSet() {
        if (this.groupingSet == null) {
            throw new SqlIllegalArgumentException("Cannot determine grouping in unresolved PIVOT");
        }
        return this.groupingSet;
    }

    private AttributeSet valuesOutput() {
        if (this.valueOutput == null) {
            ArrayList<Attribute> out = new ArrayList<Attribute>(this.aggregates.size() * this.values.size());
            if (this.aggregates.size() == 1) {
                NamedExpression agg = this.aggregates.get(0);
                for (NamedExpression value : this.values) {
                    out.add(value.toAttribute().withDataType(agg.dataType()));
                }
            } else {
                for (NamedExpression agg : this.aggregates) {
                    Alias a;
                    String name = agg.name();
                    if (agg instanceof Alias && (a = (Alias)agg).child() instanceof Function) {
                        name = ((Function)a.child()).functionName();
                    }
                    for (NamedExpression value : this.values) {
                        out.add(value.toAttribute().withName(value.name() + "_" + name).withDataType(agg.dataType()));
                    }
                }
            }
            this.valueOutput = new AttributeSet(out);
        }
        return this.valueOutput;
    }

    public AttributeMap<Literal> valuesToLiterals() {
        AttributeSet outValues = this.valuesOutput();
        AttributeMap.Builder valuesMap = AttributeMap.builder();
        int index = 0;
        for (Attribute attribute : outValues) {
            NamedExpression namedExpression = this.values.get(index % this.values.size());
            ++index;
            if (namedExpression instanceof Alias) {
                valuesMap.put(attribute, (Object)Literal.of((Expression)((Alias)namedExpression).child()));
                continue;
            }
            throw new SqlIllegalArgumentException("Unexpected alias", namedExpression);
        }
        return valuesMap.build();
    }

    public List<Attribute> output() {
        if (this.output == null) {
            this.output = new ArrayList<Attribute>((Collection<Attribute>)this.groupingSet().subtract(Expressions.references(Collections.singletonList(this.column))).combine(this.valuesOutput()));
        }
        return this.output;
    }

    public AttributeMap<Expression> aliases() {
        this.output();
        return this.aliases;
    }

    public boolean expressionsResolved() {
        return this.column.resolved() && Resolvables.resolved(this.values) && Resolvables.resolved(this.aggregates);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.values, this.aggregates, this.child());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Pivot other = (Pivot)((Object)obj);
        return Objects.equals(this.column, other.column) && Objects.equals(this.values, other.values) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals(this.child(), other.child());
    }
}

