/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.index;

import java.util.Map;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.Types;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;
import org.elasticsearch.xpack.sql.index.VersionCompatibilityChecks;
import org.elasticsearch.xpack.sql.proto.SqlVersion;

public final class IndexCompatibility {
    public static Map<String, EsField> compatible(Map<String, EsField> mapping, SqlVersion version) {
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            EsField esField = entry.getValue();
            DataType dataType = esField.getDataType();
            if (!DataTypes.isPrimitive((DataType)dataType)) {
                IndexCompatibility.compatible(esField.getProperties(), version);
                continue;
            }
            if (VersionCompatibilityChecks.isTypeSupportedInVersion(dataType, version)) continue;
            UnsupportedEsField field = new UnsupportedEsField(entry.getKey(), dataType.name(), null, esField.getProperties());
            entry.setValue((EsField)field);
            Types.propagateUnsupportedType((String)entry.getKey(), (String)dataType.name(), (Map)esField.getProperties());
        }
        return mapping;
    }

    public static EsIndex compatible(EsIndex esIndex, SqlVersion version) {
        IndexCompatibility.compatible(esIndex.mapping(), version);
        return esIndex;
    }

    public static IndexResolution compatible(IndexResolution indexResolution, SqlVersion version) {
        if (indexResolution.isValid()) {
            IndexCompatibility.compatible(indexResolution.get(), version);
        }
        return indexResolution;
    }
}

