/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class CaseProcessor
implements Processor {
    public static final String NAME = "case";
    private final List<Processor> processors;

    public CaseProcessor(List<Processor> processors) {
        this.processors = processors;
    }

    public CaseProcessor(StreamInput in) throws IOException {
        this.processors = in.readNamedWriteableCollectionAsList(Processor.class);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableCollection(this.processors);
    }

    public Object process(Object input) {
        for (int i = 0; i < this.processors.size() - 2; i += 2) {
            if (this.processors.get(i).process(input) != Boolean.TRUE) continue;
            return this.processors.get(i + 1).process(input);
        }
        return this.processors.get(this.processors.size() - 1).process(input);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseProcessor that = (CaseProcessor)o;
        return Objects.equals(this.processors, that.processors);
    }

    public int hashCode() {
        return Objects.hash(this.processors);
    }
}

