/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Base64;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SqlStreamOutput
extends OutputStreamStreamOutput {
    private final ByteArrayOutputStream bytes;

    public static SqlStreamOutput create(TransportVersion version, ZoneId zoneId) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        OutputStreamStreamOutput uncompressedOut = new OutputStreamStreamOutput(Base64.getEncoder().wrap(bytes));
        TransportVersion.writeVersion((TransportVersion)version, (StreamOutput)uncompressedOut);
        OutputStream out = CompressorFactory.COMPRESSOR.threadLocalOutputStream((OutputStream)uncompressedOut);
        return new SqlStreamOutput(bytes, out, version, zoneId);
    }

    private SqlStreamOutput(ByteArrayOutputStream bytes, OutputStream out, TransportVersion version, ZoneId zoneId) throws IOException {
        super(out);
        this.bytes = bytes;
        super.setTransportVersion(version);
        this.writeZoneId(zoneId);
    }

    public String streamAsString() throws IOException {
        return this.bytes.toString(StandardCharsets.ISO_8859_1);
    }
}

