/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.validation;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.support.MappedActionFilter;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.validation.AutoCreateDotValidator;
import org.elasticsearch.validation.CreateIndexDotValidator;
import org.elasticsearch.validation.DotPrefixValidator;
import org.elasticsearch.validation.IndexTemplateDotValidator;

public class DotPrefixValidationPlugin
extends Plugin
implements ActionPlugin {
    private final AtomicReference<List<MappedActionFilter>> actionFilters = new AtomicReference();

    public Collection<?> createComponents(Plugin.PluginServices services) {
        ThreadContext context = services.threadPool().getThreadContext();
        ClusterService clusterService = services.clusterService();
        this.actionFilters.set(List.of(new CreateIndexDotValidator(context, clusterService), new AutoCreateDotValidator(context, clusterService), new IndexTemplateDotValidator(context, clusterService)));
        return Set.of();
    }

    public Collection<MappedActionFilter> getMappedActionFilters() {
        return this.actionFilters.get();
    }

    public List<Setting<?>> getSettings() {
        return List.of(DotPrefixValidator.VALIDATE_DOT_PREFIXES, DotPrefixValidator.IGNORED_INDEX_PATTERNS_SETTING);
    }
}

