/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.mvdedupe;

import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.mvdedupe.MultivalueDedupe;

public class TopNMultivalueDedupeLong {
    static final int ALWAYS_COPY_MISSING = 300;
    final LongBlock block;
    final boolean acceptNulls;
    final Predicate<Long> isAcceptable;
    long[] work = new long[ArrayUtil.oversize((int)2, (int)8)];
    int w;

    public TopNMultivalueDedupeLong(LongBlock block, boolean acceptNulls, Predicate<Long> isAcceptable) {
        this.block = block;
        this.acceptNulls = acceptNulls;
        this.isAcceptable = isAcceptable;
    }

    public MultivalueDedupe.HashResult hashAdd(BlockFactory blockFactory, LongHash hash) {
        try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(this.block.getPositionCount());){
            boolean sawNull = false;
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        if (this.acceptNulls) {
                            sawNull = true;
                            builder.appendInt(0);
                            continue block9;
                        }
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        long v = this.block.getLong(first);
                        this.hashAdd(builder, hash, v);
                        continue block9;
                    }
                    default: {
                        if (count < 300) {
                            this.copyMissing(first, count);
                            this.hashAddUniquedWork(hash, builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.hashAddSortedWork(hash, builder);
                    }
                }
            }
            MultivalueDedupe.HashResult hashResult = new MultivalueDedupe.HashResult(builder.build(), sawNull);
            return hashResult;
        }
    }

    public IntBlock hashLookup(BlockFactory blockFactory, LongHash hash) {
        try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        if (this.acceptNulls) {
                            builder.appendInt(0);
                            continue block9;
                        }
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        long v = this.block.getLong(first);
                        this.hashLookupSingle(builder, hash, v);
                        continue block9;
                    }
                    default: {
                        if (count < 300) {
                            this.copyMissing(first, count);
                            this.hashLookupUniquedWork(hash, builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.hashLookupSortedWork(hash, builder);
                    }
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    void copyAndSort(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.w = 0;
        for (int i = first; i < end; ++i) {
            long value = this.block.getLong(i);
            if (!this.isAcceptable.test(value)) continue;
            this.work[this.w++] = value;
        }
        Arrays.sort(this.work, 0, this.w);
    }

    void copyMissing(int first, int count) {
        long v;
        this.grow(count);
        int end = first + count;
        while (first < end && !this.isAcceptable.test(v = this.block.getLong(first))) {
            ++first;
        }
        if (first == end) {
            this.w = 0;
            return;
        }
        this.work[0] = this.block.getLong(first);
        this.w = 1;
        block1: for (int i = first + 1; i < end; ++i) {
            long v2 = this.block.getLong(i);
            if (!this.isAcceptable.test(v2)) continue;
            for (int j = 0; j < this.w; ++j) {
                if (v2 == this.work[j]) continue block1;
            }
            this.work[this.w++] = v2;
        }
    }

    private void hashAddUniquedWork(LongHash hash, IntBlock.Builder builder) {
        if (this.w == 0) {
            builder.appendNull();
            return;
        }
        if (this.w == 1) {
            this.hashAddNoCheck(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            this.hashAddNoCheck(builder, hash, this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void hashAddSortedWork(LongHash hash, IntBlock.Builder builder) {
        if (this.w == 0) {
            builder.appendNull();
            return;
        }
        if (this.w == 1) {
            this.hashAddNoCheck(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        long prev = this.work[0];
        this.hashAddNoCheck(builder, hash, prev);
        for (int i = 1; i < this.w; ++i) {
            if (TopNMultivalueDedupeLong.valuesEqual(prev, this.work[i])) continue;
            prev = this.work[i];
            this.hashAddNoCheck(builder, hash, prev);
        }
        builder.endPositionEntry();
    }

    private void hashLookupUniquedWork(LongHash hash, IntBlock.Builder builder) {
        long nextLookup;
        if (this.w == 0) {
            builder.appendNull();
            return;
        }
        if (this.w == 1) {
            this.hashLookupSingle(builder, hash, this.work[0]);
            return;
        }
        int i = 1;
        long firstLookup = this.hashLookup(hash, this.work[0]);
        while (firstLookup < 0L) {
            if (i >= this.w) {
                builder.appendNull();
                return;
            }
            firstLookup = this.hashLookup(hash, this.work[i]);
            ++i;
        }
        boolean foundSecond = false;
        while (i < this.w) {
            nextLookup = this.hashLookup(hash, this.work[i]);
            if (nextLookup >= 0L) {
                builder.beginPositionEntry();
                this.appendFound(builder, firstLookup);
                this.appendFound(builder, nextLookup);
                ++i;
                foundSecond = true;
                break;
            }
            ++i;
        }
        if (!foundSecond) {
            this.appendFound(builder, firstLookup);
            return;
        }
        while (i < this.w) {
            nextLookup = this.hashLookup(hash, this.work[i]);
            if (nextLookup >= 0L) {
                this.appendFound(builder, nextLookup);
            }
            ++i;
        }
        builder.endPositionEntry();
    }

    private void hashLookupSortedWork(LongHash hash, IntBlock.Builder builder) {
        long nextLookup;
        if (this.w == 1) {
            this.hashLookupSingle(builder, hash, this.work[0]);
            return;
        }
        int i = 1;
        long prev = this.work[0];
        long firstLookup = this.hashLookup(hash, prev);
        while (firstLookup < 0L) {
            if (i >= this.w) {
                builder.appendNull();
                return;
            }
            prev = this.work[i];
            firstLookup = this.hashLookup(hash, prev);
            ++i;
        }
        boolean foundSecond = false;
        while (i < this.w) {
            if (!TopNMultivalueDedupeLong.valuesEqual(prev, this.work[i]) && (nextLookup = this.hashLookup(hash, this.work[i])) >= 0L) {
                prev = this.work[i];
                builder.beginPositionEntry();
                this.appendFound(builder, firstLookup);
                this.appendFound(builder, nextLookup);
                ++i;
                foundSecond = true;
                break;
            }
            ++i;
        }
        if (!foundSecond) {
            this.appendFound(builder, firstLookup);
            return;
        }
        while (i < this.w) {
            if (!TopNMultivalueDedupeLong.valuesEqual(prev, this.work[i]) && (nextLookup = this.hashLookup(hash, this.work[i])) >= 0L) {
                prev = this.work[i];
                this.appendFound(builder, nextLookup);
            }
            ++i;
        }
        builder.endPositionEntry();
    }

    private void grow(int size) {
        this.work = ArrayUtil.grow((long[])this.work, (int)size);
    }

    private void hashAdd(IntBlock.Builder builder, LongHash hash, long v) {
        if (this.isAcceptable.test(v)) {
            this.hashAddNoCheck(builder, hash, v);
        } else {
            builder.appendNull();
        }
    }

    private void hashAddNoCheck(IntBlock.Builder builder, LongHash hash, long v) {
        this.appendFound(builder, hash.add(v));
    }

    private long hashLookup(LongHash hash, long v) {
        return this.isAcceptable.test(v) ? hash.find(v) : -1L;
    }

    private void hashLookupSingle(IntBlock.Builder builder, LongHash hash, long v) {
        long found = this.hashLookup(hash, v);
        if (found >= 0L) {
            this.appendFound(builder, found);
        } else {
            builder.appendNull();
        }
    }

    private void appendFound(IntBlock.Builder builder, long found) {
        builder.appendInt(Math.toIntExact(BlockHash.hashOrdToGroupNullReserved(found)));
    }

    private static boolean valuesEqual(long lhs, long rhs) {
        return lhs == rhs;
    }
}

