/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

final class DriverScheduler {
    private final AtomicReference<Runnable> delayedTask = new AtomicReference();
    private final AtomicReference<AbstractRunnable> scheduledTask = new AtomicReference();
    private final AtomicBoolean completing = new AtomicBoolean();

    DriverScheduler() {
    }

    void addOrRunDelayedTask(Runnable task) {
        Runnable toRun;
        this.delayedTask.set(task);
        if (this.completing.get() && (toRun = (Runnable)this.delayedTask.getAndSet(null)) != null) {
            assert (task == toRun);
            toRun.run();
        }
    }

    void scheduleOrRunTask(Executor executor, final AbstractRunnable task) {
        AbstractRunnable existing = this.scheduledTask.getAndSet(task);
        assert (existing == null) : existing;
        Executor executorToUse = this.completing.get() ? EsExecutors.DIRECT_EXECUTOR_SERVICE : executor;
        executorToUse.execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                assert (e instanceof EsRejectedExecutionException) : new AssertionError((Object)e);
                if (DriverScheduler.this.scheduledTask.getAndUpdate(t -> t == task ? null : t) == task) {
                    task.onFailure(e);
                }
            }

            protected void doRun() {
                AbstractRunnable toRun = DriverScheduler.this.scheduledTask.getAndSet(null);
                if (toRun == task) {
                    task.run();
                }
            }
        });
    }

    void runPendingTasks() {
        this.completing.set(true);
        for (AtomicReference<Runnable> taskHolder : List.of(this.scheduledTask, this.delayedTask)) {
            Runnable task = taskHolder.getAndSet(null);
            if (task == null) continue;
            task.run();
        }
    }
}

