/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingToIteratorOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public class ColumnLoadOperator
extends AbstractPageMappingToIteratorOperator {
    private final Values values;
    private final int positionsOrd;
    static final ByteSizeValue TARGET_BLOCK_SIZE = ByteSizeValue.ofKb((long)10L);

    public ColumnLoadOperator(Values values, int positionsOrd) {
        this.positionsOrd = positionsOrd;
        this.values = ColumnLoadOperator.clone(values);
    }

    static Values clone(Values values) {
        Block block = values.block;
        try (Block.Builder builder = block.elementType().newBlockBuilder(block.getPositionCount(), block.blockFactory());){
            builder.copyFrom(block, 0, block.getPositionCount());
            Values values2 = new Values(values.name, builder.build());
            return values2;
        }
    }

    @Override
    protected ReleasableIterator<Page> receive(Page page) {
        return ColumnLoadOperator.appendBlocks(page, this.values.block.lookup((IntBlock)page.getBlock(this.positionsOrd), TARGET_BLOCK_SIZE));
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.values.block, () -> super.close()});
    }

    @Override
    public String toString() {
        return "ColumnLoad[values=" + String.valueOf(this.values) + ", positions=" + this.positionsOrd + "]";
    }

    public record Values(String name, Block block) {
        @Override
        public String toString() {
            return this.name + ":" + String.valueOf((Object)this.block.elementType());
        }
    }

    public record Factory(Values values, int positionsOrd) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ColumnLoadOperator(this.values, this.positionsOrd);
        }

        @Override
        public String describe() {
            return "ColumnLoad[values=" + String.valueOf(this.values) + ", positions=" + this.positionsOrd + "]";
        }
    }
}

