/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;

public class SingletonOrdinalsBuilder
implements BlockLoader.SingletonOrdinalsBuilder,
Releasable,
Block.Builder {
    private final BlockFactory blockFactory;
    private final SortedDocValues docValues;
    private int minOrd = Integer.MAX_VALUE;
    private int maxOrd = Integer.MIN_VALUE;
    private final int[] ords;
    private int count;
    private final boolean isDense;

    public SingletonOrdinalsBuilder(BlockFactory blockFactory, SortedDocValues docValues, int count, boolean isDense) {
        this.blockFactory = blockFactory;
        this.docValues = docValues;
        blockFactory.adjustBreaker(SingletonOrdinalsBuilder.ordsSize(count));
        this.ords = new int[count];
        this.isDense = isDense;
    }

    @Override
    public SingletonOrdinalsBuilder appendNull() {
        assert (!this.isDense);
        this.ords[this.count++] = -1;
        return this;
    }

    public SingletonOrdinalsBuilder appendOrd(int ord) {
        this.ords[this.count++] = ord;
        this.minOrd = Math.min(this.minOrd, ord);
        this.maxOrd = Math.max(this.maxOrd, ord);
        return this;
    }

    public BlockLoader.SingletonOrdinalsBuilder appendOrds(int[] values, int from, int length, int minOrd, int maxOrd) {
        System.arraycopy(values, from, this.ords, this.count, length);
        this.count += length;
        this.minOrd = Math.min(this.minOrd, minOrd);
        this.maxOrd = Math.max(this.maxOrd, maxOrd);
        return this;
    }

    @Override
    public SingletonOrdinalsBuilder beginPositionEntry() {
        throw new UnsupportedOperationException("should only have one value per doc");
    }

    @Override
    public SingletonOrdinalsBuilder endPositionEntry() {
        throw new UnsupportedOperationException("should only have one value per doc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BytesRefBlock tryBuildConstantBlock() {
        OrdinalBytesRefBlock ordinalBytesRefBlock;
        block8: {
            BytesRef v;
            if (this.minOrd != this.maxOrd) {
                return null;
            }
            if (!this.isDense) {
                for (int ord : this.ords) {
                    if (ord != -1) continue;
                    return null;
                }
            }
            try {
                v = BytesRef.deepCopyOf((BytesRef)this.docValues.lookupOrd(this.minOrd));
            }
            catch (IOException e) {
                throw new UncheckedIOException("failed to lookup ordinals", e);
            }
            BytesRefVector bytes = null;
            IntVector ordinals = null;
            boolean success = false;
            try {
                bytes = this.blockFactory.newConstantBytesRefVector(v, 1);
                ordinals = this.blockFactory.newConstantIntVector(0, this.ords.length);
                OrdinalBytesRefBlock result = new OrdinalBytesRefBlock(ordinals.asBlock(), bytes);
                success = true;
                ordinalBytesRefBlock = result;
                if (success) break block8;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close((Releasable[])new Releasable[]{bytes, ordinals});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{bytes, ordinals});
        }
        return ordinalBytesRefBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BytesRefBlock buildOrdinal() {
        OrdinalBytesRefBlock ordinalBytesRefBlock;
        int valueCount = this.maxOrd - this.minOrd + 1;
        long breakerSize = SingletonOrdinalsBuilder.ordsSize(valueCount);
        this.blockFactory.adjustBreaker(breakerSize);
        BytesRefVector bytesVector = null;
        IntBlock ordinalBlock = null;
        try {
            int[] newOrds = new int[valueCount];
            Arrays.fill(newOrds, -1);
            if (this.isDense) {
                for (int ord : this.ords) {
                    newOrds[ord - this.minOrd] = 0;
                }
            } else {
                for (int ord : this.ords) {
                    if (ord == -1) continue;
                    newOrds[ord - this.minOrd] = 0;
                }
            }
            try {
                int nextOrd = -1;
                BytesRef bytesRef = this.minOrd != Integer.MAX_VALUE ? this.docValues.lookupOrd(this.minOrd) : null;
                int estimatedSize = bytesRef != null ? Math.min(valueCount, this.ords.length) * bytesRef.length : Math.min(valueCount, this.ords.length);
                try (BytesRefVector.Builder bytesBuilder = this.blockFactory.newBytesRefVectorBuilder(estimatedSize);){
                    int i;
                    if (bytesRef != null) {
                        newOrds[0] = ++nextOrd;
                        bytesBuilder.appendBytesRef(bytesRef);
                    }
                    int n = i = bytesRef != null ? 1 : 0;
                    while (i < newOrds.length) {
                        if (newOrds[i] != -1) {
                            newOrds[i] = ++nextOrd;
                            bytesBuilder.appendBytesRef(this.docValues.lookupOrd(i + this.minOrd));
                        }
                        ++i;
                    }
                    bytesVector = bytesBuilder.build();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("error resolving ordinals", e);
            }
            if (this.isDense) {
                for (int i = 0; i < this.ords.length; ++i) {
                    this.ords[i] = newOrds[this.ords[i] - this.minOrd];
                }
                ordinalBlock = this.blockFactory.newIntArrayVector(this.ords, this.ords.length).asBlock();
            } else {
                try (IntBlock.Builder ordinalsBuilder = this.blockFactory.newIntBlockBuilder(this.ords.length);){
                    for (int ord : this.ords) {
                        if (ord == -1) {
                            ordinalsBuilder.appendNull();
                            continue;
                        }
                        ordinalsBuilder.appendInt(newOrds[ord - this.minOrd]);
                    }
                    ordinalBlock = ordinalsBuilder.build();
                }
            }
            OrdinalBytesRefBlock result = new OrdinalBytesRefBlock(ordinalBlock, bytesVector);
            bytesVector = null;
            ordinalBlock = null;
            ordinalBytesRefBlock = result;
        }
        catch (Throwable throwable) {
            Releasables.close((Releasable[])new Releasable[]{() -> this.blockFactory.adjustBreaker(-breakerSize), ordinalBlock, bytesVector});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{() -> this.blockFactory.adjustBreaker(-breakerSize), ordinalBlock, bytesVector});
        return ordinalBytesRefBlock;
    }

    /*
     * Exception decompiling
     */
    BytesRefBlock buildRegularBlock() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long estimatedBytes() {
        long overhead = this.shouldBuildOrdinalsBlock() ? 5L : 20L;
        return (long)this.ords.length * overhead;
    }

    @Override
    public BytesRefBlock build() {
        BytesRefBlock constantBlock = this.tryBuildConstantBlock();
        if (constantBlock != null) {
            return constantBlock;
        }
        return this.shouldBuildOrdinalsBlock() ? this.buildOrdinal() : this.buildRegularBlock();
    }

    boolean shouldBuildOrdinalsBlock() {
        if (this.minOrd <= this.maxOrd) {
            int numOrds = this.maxOrd - this.minOrd + 1;
            return OrdinalBytesRefBlock.isDense(this.ords.length, numOrds);
        }
        return false;
    }

    public void close() {
        this.blockFactory.adjustBreaker(-SingletonOrdinalsBuilder.ordsSize(this.ords.length));
    }

    @Override
    public Block.Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
        throw new UnsupportedOperationException();
    }

    private static long ordsSize(int ordsCount) {
        return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + ordsCount * 4;
    }

    static int compactToUnique(int[] sortedOrds) {
        Arrays.sort(sortedOrds);
        int uniqueSize = 0;
        int prev = -1;
        for (int i = 0; i < sortedOrds.length; ++i) {
            if (sortedOrds[i] == prev) continue;
            sortedOrds[uniqueSize++] = prev = sortedOrds[i];
        }
        return uniqueSize;
    }
}

