/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntLookup;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class IntArrayBlock
extends AbstractArrayBlock
implements IntBlock {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntArrayBlock.class);
    private final IntArrayVector vector;

    IntArrayBlock(int[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        this(new IntArrayVector(values, firstValueIndexes == null ? positionCount : firstValueIndexes[positionCount], blockFactory), positionCount, firstValueIndexes, nulls, mvOrdering);
    }

    private IntArrayBlock(IntArrayVector vector, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering);
        this.vector = vector;
        assert (firstValueIndexes != null ? firstValueIndexes[this.getPositionCount()] == vector.getPositionCount() : vector.getPositionCount() == this.getPositionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IntArrayBlock readArrayBlock(BlockFactory blockFactory, BlockStreamInput in) throws IOException {
        AbstractArrayBlock.SubFields sub = new AbstractArrayBlock.SubFields(blockFactory, (StreamInput)in);
        IntArrayVector vector = null;
        boolean success = false;
        try {
            vector = IntArrayVector.readArrayVector(sub.vectorPositions(), (StreamInput)in, blockFactory);
            IntArrayBlock block = new IntArrayBlock(vector, sub.positionCount, sub.firstValueIndexes, sub.nullsMask, sub.mvOrdering);
            blockFactory.adjustBreaker(block.ramBytesUsed() - vector.ramBytesUsed() - sub.bytesReserved);
            success = true;
            IntArrayBlock intArrayBlock = block;
            return intArrayBlock;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable)vector);
                blockFactory.adjustBreaker(-sub.bytesReserved);
            }
        }
    }

    void writeArrayBlock(StreamOutput out) throws IOException {
        this.writeSubFields(out);
        this.vector.writeArrayVector(this.vector.getPositionCount(), out);
    }

    @Override
    public IntVector asVector() {
        return null;
    }

    @Override
    public int getInt(int valueIndex) {
        return this.vector.getInt(valueIndex);
    }

    @Override
    public IntBlock filter(int ... positions) {
        try (IntBlock.Builder builder = this.blockFactory().newIntBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendInt(this.getInt(first));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendInt(this.getInt(first + c));
                }
                builder.endPositionEntry();
            }
            IntBlock intBlock = builder.mvOrdering(this.mvOrdering()).build();
            return intBlock;
        }
    }

    @Override
    public IntBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return this;
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return this;
            }
            return (IntBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (IntBlock.Builder builder = this.blockFactory().newIntBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (!mask.getBoolean(p)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int start = this.getFirstValueIndex(p);
                if (valueCount == 1) {
                    builder.appendInt(this.getInt(start));
                    continue;
                }
                int end = start + valueCount;
                builder.beginPositionEntry();
                for (int i = start; i < end; ++i) {
                    builder.appendInt(this.getInt(i));
                }
                builder.endPositionEntry();
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    public ReleasableIterator<IntBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new IntLookup(this, positions, targetBlockSize);
    }

    @Override
    public ElementType elementType() {
        return ElementType.INT;
    }

    @Override
    public IntBlock expand() {
        if (this.firstValueIndexes == null) {
            this.incRef();
            return this;
        }
        if (this.nullsMask == null) {
            this.vector.incRef();
            return this.vector.asBlock();
        }
        int expandedPositionCount = this.vector.getPositionCount();
        long bitSetRamUsedEstimate = Math.max((long)this.nullsMask.size(), BlockRamUsageEstimator.sizeOfBitSet(expandedPositionCount));
        this.blockFactory().adjustBreaker(bitSetRamUsedEstimate);
        IntArrayBlock expanded = new IntArrayBlock(this.vector, expandedPositionCount, null, this.shiftNullsToExpandedPositions(), Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        this.blockFactory().adjustBreaker(expanded.ramBytesUsedOnlyBlock() - bitSetRamUsedEstimate);
        this.vector.incRef();
        return expanded;
    }

    private long ramBytesUsedOnlyBlock() {
        return BASE_RAM_BYTES_USED + BlockRamUsageEstimator.sizeOf(this.firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(this.nullsMask);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsedOnlyBlock() + this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntBlock) {
            IntBlock that = (IntBlock)obj;
            return IntBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return IntBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + String.valueOf((Object)this.mvOrdering()) + ", vector=" + String.valueOf(this.vector) + "]";
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsedOnlyBlock());
        Releasables.closeExpectNoException((Releasable)this.vector);
    }
}

