/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.nio.ByteOrder;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.spatial.PointType;
import org.elasticsearch.compute.aggregation.spatial.SpatialAggregationUtils;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.SpatialEnvelopeVisitor;
import org.elasticsearch.geometry.utils.WellKnownBinary;

final class SpatialExtentStateWrappedLongitudeState
implements AggregatorState {
    private static final PointType POINT_TYPE = PointType.GEO;
    private boolean seen = false;
    private int top = Integer.MIN_VALUE;
    private int bottom = Integer.MAX_VALUE;
    private int negLeft = Integer.MAX_VALUE;
    private int negRight = Integer.MIN_VALUE;
    private int posLeft = Integer.MAX_VALUE;
    private int posRight = Integer.MIN_VALUE;
    private final SpatialEnvelopeVisitor.GeoPointVisitor geoPointVisitor = new SpatialEnvelopeVisitor.GeoPointVisitor(SpatialEnvelopeVisitor.WrapLongitude.WRAP);

    SpatialExtentStateWrappedLongitudeState() {
    }

    public void close() {
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        assert (blocks.length >= offset + 6);
        BlockFactory blockFactory = driverContext.blockFactory();
        blocks[offset + 0] = blockFactory.newConstantIntBlockWith(this.top, 1);
        blocks[offset + 1] = blockFactory.newConstantIntBlockWith(this.bottom, 1);
        blocks[offset + 2] = blockFactory.newConstantIntBlockWith(this.negLeft, 1);
        blocks[offset + 3] = blockFactory.newConstantIntBlockWith(this.negRight, 1);
        blocks[offset + 4] = blockFactory.newConstantIntBlockWith(this.posLeft, 1);
        blocks[offset + 5] = blockFactory.newConstantIntBlockWith(this.posRight, 1);
    }

    public void add(Geometry geo) {
        this.geoPointVisitor.reset();
        if (((Boolean)geo.visit((GeometryVisitor)new SpatialEnvelopeVisitor((SpatialEnvelopeVisitor.PointVisitor)this.geoPointVisitor))).booleanValue()) {
            this.add(POINT_TYPE.encoder().encodeY(this.geoPointVisitor.getTop()), POINT_TYPE.encoder().encodeY(this.geoPointVisitor.getBottom()), SpatialAggregationUtils.encodeLongitude(this.geoPointVisitor.getNegLeft()), SpatialAggregationUtils.encodeLongitude(this.geoPointVisitor.getNegRight()), SpatialAggregationUtils.encodeLongitude(this.geoPointVisitor.getPosLeft()), SpatialAggregationUtils.encodeLongitude(this.geoPointVisitor.getPosRight()));
        }
    }

    public void add(int p, IntBlock values) {
        if (values.getValueCount(p) != 6) {
            throw new IllegalArgumentException("Expected 6 values, got " + values.getValueCount(p));
        }
        int i = values.getFirstValueIndex(p);
        int top = values.getInt(i++);
        int bottom = values.getInt(i++);
        int negLeft = values.getInt(i++);
        int negRight = values.getInt(i++);
        int posLeft = values.getInt(i++);
        int posRight = values.getInt(i);
        this.add(top, bottom, negLeft, negRight, posLeft, posRight);
    }

    public void add(int top, int bottom, int negLeft, int negRight, int posLeft, int posRight) {
        this.seen = true;
        this.top = Math.max(this.top, top);
        this.bottom = Math.min(this.bottom, bottom);
        this.negLeft = Math.min(this.negLeft, negLeft);
        this.negRight = SpatialAggregationUtils.maxNeg(this.negRight, negRight);
        this.posLeft = SpatialAggregationUtils.minPos(this.posLeft, posLeft);
        this.posRight = Math.max(this.posRight, posRight);
    }

    public void add(long encoded) {
        int x = POINT_TYPE.extractX(encoded);
        int y = POINT_TYPE.extractY(encoded);
        this.add(y, y, x, x, x, x);
    }

    public Block toBlock(DriverContext driverContext) {
        BlockFactory factory = driverContext.blockFactory();
        return this.seen ? factory.newConstantBytesRefBlockWith(new BytesRef(this.toWKB()), 1) : factory.newConstantNullBlock(1);
    }

    private byte[] toWKB() {
        return WellKnownBinary.toWKB((Geometry)SpatialExtentStateWrappedLongitudeState.asRectangle(this.top, this.bottom, this.negLeft, this.negRight, this.posLeft, this.posRight), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    }

    static Rectangle asRectangle(int top, int bottom, int negLeft, int negRight, int posLeft, int posRight) {
        return SpatialEnvelopeVisitor.GeoPointVisitor.getResult((double)GeoEncodingUtils.decodeLatitude((int)top), (double)GeoEncodingUtils.decodeLatitude((int)bottom), (double)(negLeft <= 0 ? SpatialAggregationUtils.decodeLongitude(negLeft) : Double.POSITIVE_INFINITY), (double)(negRight <= 0 ? SpatialAggregationUtils.decodeLongitude(negRight) : Double.NEGATIVE_INFINITY), (double)(posLeft >= 0 ? SpatialAggregationUtils.decodeLongitude(posLeft) : Double.POSITIVE_INFINITY), (double)(posRight >= 0 ? SpatialAggregationUtils.decodeLongitude(posRight) : Double.NEGATIVE_INFINITY), (SpatialEnvelopeVisitor.WrapLongitude)SpatialEnvelopeVisitor.WrapLongitude.WRAP);
    }
}

