/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.CategorizeBlockHash;
import org.elasticsearch.compute.aggregation.blockhash.PackedValuesBlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.analysis.AnalysisRegistry;

public class CategorizePackedValuesBlockHash
extends BlockHash {
    private final List<BlockHash.GroupSpec> specs;
    private final AggregatorMode aggregatorMode;
    private final Block[] blocks;
    private final CategorizeBlockHash categorizeBlockHash;
    private final PackedValuesBlockHash packedValuesBlockHash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CategorizePackedValuesBlockHash(List<BlockHash.GroupSpec> specs, BlockFactory blockFactory, AggregatorMode aggregatorMode, AnalysisRegistry analysisRegistry, int emitBatchSize) {
        super(blockFactory);
        assert (specs.get(0).categorizeDef() != null);
        this.specs = specs;
        this.aggregatorMode = aggregatorMode;
        this.blocks = new Block[specs.size()];
        ArrayList<BlockHash.GroupSpec> delegateSpecs = new ArrayList<BlockHash.GroupSpec>();
        delegateSpecs.add(new BlockHash.GroupSpec(0, ElementType.INT));
        for (int i = 1; i < specs.size(); ++i) {
            delegateSpecs.add(new BlockHash.GroupSpec(i, specs.get(i).elementType()));
        }
        boolean success = false;
        try {
            this.categorizeBlockHash = new CategorizeBlockHash(blockFactory, specs.get(0).channel(), aggregatorMode, specs.get(0).categorizeDef(), analysisRegistry);
            this.packedValuesBlockHash = new PackedValuesBlockHash(delegateSpecs, blockFactory, emitBatchSize);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        try (IntBlock categories = this.getCategories(page);){
            this.blocks[0] = categories;
            for (int i = 1; i < this.specs.size(); ++i) {
                this.blocks[i] = page.getBlock(this.specs.get(i).channel());
            }
            this.packedValuesBlockHash.add(new Page(this.blocks), addInput);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private IntBlock getCategories(Page page) {
        if (!this.aggregatorMode.isInputPartial()) {
            return this.categorizeBlockHash.addInitial(page);
        }
        BytesRefBlock stateBlock = (BytesRefBlock)page.getBlock(0);
        BytesRef stateBytes = stateBlock.getBytesRef(0, new BytesRef());
        try (StreamInput in = new BytesArray(stateBytes).streamInput();){
            IntBlock intBlock;
            block15: {
                BytesRef categorizerState = in.readBytesRef();
                IntVector ids = IntVector.readFrom(this.blockFactory, in);
                try {
                    intBlock = this.categorizeBlockHash.recategorize(categorizerState, ids).asBlock();
                    if (ids == null) break block15;
                }
                catch (Throwable throwable) {
                    if (ids != null) {
                        try {
                            ids.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ids.close();
            }
            return intBlock;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Block[] getKeys() {
        Block[] keys;
        block22: {
            BytesRef state;
            keys = this.packedValuesBlockHash.getKeys();
            if (!this.aggregatorMode.isOutputPartial()) {
                try (BytesRefBlock regexes = (BytesRefBlock)this.categorizeBlockHash.getKeys()[0];
                     BytesRefBlock.Builder builder = this.blockFactory.newBytesRefBlockBuilder(keys[0].getPositionCount());){
                    IntVector idsVector = (IntVector)keys[0].asVector();
                    int idsOffset = this.categorizeBlockHash.seenNull() ? 0 : -1;
                    BytesRef scratch = new BytesRef();
                    for (int i = 0; i < idsVector.getPositionCount(); ++i) {
                        int id = idsVector.getInt(i);
                        if (id == 0) {
                            builder.appendNull();
                            continue;
                        }
                        builder.appendBytesRef(regexes.getBytesRef(id + idsOffset, scratch));
                    }
                    keys[0].close();
                    keys[0] = builder.build();
                    break block22;
                }
            }
            try (BytesStreamOutput out = new BytesStreamOutput();){
                out.writeBytesRef(this.categorizeBlockHash.serializeCategorizer());
                ((IntVector)keys[0].asVector()).writeTo((StreamOutput)out);
                state = out.bytes().toBytesRef();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            keys[0].close();
            keys[0] = this.blockFactory.newConstantBytesRefBlockWith(state, keys[0].getPositionCount());
        }
        return keys;
    }

    @Override
    public IntVector nonEmpty() {
        return this.packedValuesBlockHash.nonEmpty();
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return this.packedValuesBlockHash.seenGroupIds(bigArrays);
    }

    @Override
    public final ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException();
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.categorizeBlockHash, this.packedValuesBlockHash});
    }
}

