/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.ValuesBytesRefAggregators;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ValuesBytesRefAggregator {
    ValuesBytesRefAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, BytesRef v) {
        state.values.add(v);
    }

    public static void combineIntermediate(SingleState state, BytesRefBlock values) {
        BytesRef scratch = new BytesRef();
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesBytesRefAggregator.combine(state, values.getBytesRef(i, scratch));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext);
    }

    public static GroupingAggregatorFunction.AddInput wrapAddInput(GroupingAggregatorFunction.AddInput delegate, GroupingState state, BytesRefBlock values) {
        return ValuesBytesRefAggregators.wrapAddInput(delegate, state, values);
    }

    public static GroupingAggregatorFunction.AddInput wrapAddInput(GroupingAggregatorFunction.AddInput delegate, GroupingState state, BytesRefVector values) {
        return ValuesBytesRefAggregators.wrapAddInput(delegate, state, values);
    }

    public static void combine(GroupingState state, int groupId, BytesRef v) {
        state.addValue(groupId, v);
    }

    public static void combineIntermediate(GroupingState state, int positionOffset, IntVector groups, BytesRefBlock values) {
        ValuesBytesRefAggregators.combineIntermediateInputValues(state, positionOffset, groups, values);
    }

    public static void combineIntermediate(GroupingState state, int positionOffset, IntBlock groups, BytesRefBlock values) {
        ValuesBytesRefAggregators.combineIntermediateInputValues(state, positionOffset, groups, values);
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.toBlock(ctx.blockFactory(), selected);
    }

    public static class SingleState
    implements AggregatorState {
        private final BytesRefHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new BytesRefHash(1L, bigArrays);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            BytesRef scratch = new BytesRef();
            if (this.values.size() == 1L) {
                return blockFactory.newConstantBytesRefBlockWith(BytesRef.deepCopyOf((BytesRef)this.values.get(0L, scratch)), 1);
            }
            try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendBytesRef(this.values.get((long)id, scratch));
                    ++id;
                }
                builder.endPositionEntry();
                BytesRefBlock bytesRefBlock = builder.build();
                return bytesRefBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private final BlockFactory blockFactory;
        BytesRefHash bytes;
        private IntArray firstValues;
        private final NextValues nextValues;

        private GroupingState(DriverContext driverContext) {
            this.blockFactory = driverContext.blockFactory();
            boolean success = false;
            try {
                this.bytes = new BytesRefHash(1L, driverContext.bigArrays());
                this.firstValues = driverContext.bigArrays().newIntArray(1L, true);
                this.nextValues = new NextValues(driverContext.blockFactory());
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        void addValueOrdinal(int groupId, int valueOrdinal) {
            if ((long)groupId < this.firstValues.size()) {
                int current = this.firstValues.get((long)groupId) - 1;
                if (current < 0) {
                    this.firstValues.set((long)groupId, valueOrdinal + 1);
                } else if (current != valueOrdinal) {
                    this.nextValues.addValue(groupId, valueOrdinal);
                }
            } else {
                this.firstValues = this.blockFactory.bigArrays().grow(this.firstValues, (long)(groupId + 1));
                this.firstValues.set((long)groupId, valueOrdinal + 1);
            }
        }

        void addValue(int groupId, BytesRef v) {
            int valueOrdinal = Math.toIntExact(BlockHash.hashOrdToGroup(this.bytes.add(v)));
            this.addValueOrdinal(groupId, valueOrdinal);
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            this.nextValues.prepareForEmitting(selected);
            if (OrdinalBytesRefBlock.isDense(this.firstValues.size() + this.nextValues.hashes.size(), this.bytes.size())) {
                return this.buildOrdinalOutputBlock(blockFactory, selected);
            }
            return this.buildOutputBlock(blockFactory, selected);
        }

        Block buildOutputBlock(BlockFactory blockFactory, IntVector selected) {
            BytesRef scratch = new BytesRef();
            int[] nextValueCounts = this.nextValues.selectedCounts;
            try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(selected.getPositionCount());){
                int nextValuesStart = 0;
                for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int nextValuesEnd;
                    int firstValue;
                    int group = selected.getInt(s);
                    int n = firstValue = (long)group >= this.firstValues.size() ? -1 : this.firstValues.get((long)group) - 1;
                    if (firstValue < 0) {
                        builder.appendNull();
                        continue;
                    }
                    int n2 = nextValuesEnd = nextValueCounts != null ? nextValueCounts[group] : nextValuesStart;
                    if (nextValuesEnd == nextValuesStart) {
                        builder.appendBytesRef(this.bytes.get((long)firstValue, scratch));
                        continue;
                    }
                    builder.beginPositionEntry();
                    builder.appendBytesRef(this.bytes.get((long)firstValue, scratch));
                    for (int i = nextValuesStart; i < nextValuesEnd; ++i) {
                        int nextValue = this.nextValues.getValue(i);
                        builder.appendBytesRef(this.bytes.get((long)nextValue, scratch));
                    }
                    builder.endPositionEntry();
                    nextValuesStart = nextValuesEnd;
                }
                BytesRefBlock bytesRefBlock = builder.build();
                return bytesRefBlock;
            }
        }

        /*
         * Loose catch block
         */
        Block buildOrdinalOutputBlock(BlockFactory blockFactory, IntVector selected) {
            OrdinalBytesRefBlock ordinalBytesRefBlock;
            IntBlock.Builder builder;
            BytesRefArray dictArray;
            OrdinalBytesRefBlock result;
            IntBlock ordinals;
            BytesRefVector dict;
            block15: {
                block14: {
                    dict = null;
                    ordinals = null;
                    result = null;
                    dictArray = this.bytes.takeBytesRefsOwnership();
                    this.bytes = null;
                    int estimateSize = Math.toIntExact(this.firstValues.size() + this.nextValues.hashes.size());
                    int[] nextValueCounts = this.nextValues.selectedCounts;
                    builder = blockFactory.newIntBlockBuilder(estimateSize);
                    int nextValuesStart = 0;
                    for (int s = 0; s < selected.getPositionCount(); ++s) {
                        int nextValuesEnd;
                        int firstValue;
                        int group = selected.getInt(s);
                        int n = firstValue = (long)group >= this.firstValues.size() ? -1 : this.firstValues.get((long)group) - 1;
                        if (firstValue < 0) {
                            builder.appendNull();
                            continue;
                        }
                        int n2 = nextValuesEnd = nextValueCounts != null ? nextValueCounts[group] : nextValuesStart;
                        if (nextValuesEnd == nextValuesStart) {
                            builder.appendInt(firstValue);
                        } else {
                            builder.beginPositionEntry();
                            builder.appendInt(firstValue);
                            for (int i = nextValuesStart; i < nextValuesEnd; ++i) {
                                builder.appendInt(this.nextValues.getValue(i));
                            }
                            builder.endPositionEntry();
                        }
                        nextValuesStart = nextValuesEnd;
                    }
                    ordinals = builder.build();
                    dict = blockFactory.newBytesRefArrayVector(dictArray, Math.toIntExact(dictArray.size()));
                    dictArray = null;
                    ordinalBytesRefBlock = result = new OrdinalBytesRefBlock(ordinals, dict);
                    if (builder == null) break block14;
                    builder.close();
                }
                if (result != null) break block15;
                Releasables.close((Releasable[])new Releasable[]{dictArray, dict, ordinals});
            }
            return ordinalBytesRefBlock;
            {
                catch (Throwable throwable) {
                    try {
                        if (builder != null) {
                            try {
                                builder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (result == null) {
                            Releasables.close((Releasable[])new Releasable[]{dictArray, dict, ordinals});
                        }
                        throw throwable3;
                    }
                }
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.bytes, this.firstValues, this.nextValues});
        }
    }

    private static class NextValues
    implements Releasable {
        private final BlockFactory blockFactory;
        private final LongHash hashes;
        private int[] selectedCounts = null;
        private int[] ids = null;
        private long extraMemoryUsed = 0L;

        private NextValues(BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
            this.hashes = new LongHash(1L, blockFactory.bigArrays());
        }

        void addValue(int groupId, int v) {
            this.hashes.add((long)groupId << 32 | (long)v & 0xFFFFFFFFL);
        }

        int getValue(int index) {
            long both = this.hashes.get((long)this.ids[index]);
            return (int)(both & 0xFFFFFFFFL);
        }

        private void reserveBytesForIntArray(long numElements) {
            long adjust = RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + numElements * 4L));
            this.blockFactory.adjustBreaker(adjust);
            this.extraMemoryUsed += adjust;
        }

        private void prepareForEmitting(IntVector selected) {
            if (this.hashes.size() == 0L) {
                return;
            }
            int selectedCountsLen = selected.max() + 1;
            this.reserveBytesForIntArray(selectedCountsLen);
            this.selectedCounts = new int[selectedCountsLen];
            int id = 0;
            while ((long)id < this.hashes.size()) {
                long both = this.hashes.get((long)id);
                int group = (int)(both >>> 32);
                if (group < this.selectedCounts.length) {
                    int n = group;
                    this.selectedCounts[n] = this.selectedCounts[n] - 1;
                }
                ++id;
            }
            int total = 0;
            for (int s = 0; s < selected.getPositionCount(); ++s) {
                int group = selected.getInt(s);
                int count = -this.selectedCounts[group];
                this.selectedCounts[group] = total;
                total += count;
            }
            this.reserveBytesForIntArray(total);
            this.ids = new int[total];
            int id2 = 0;
            while ((long)id2 < this.hashes.size()) {
                int group;
                long both = this.hashes.get((long)id2);
                int n = group = (int)(both >>> 32);
                int n2 = this.selectedCounts[n];
                this.selectedCounts[n] = n2 + 1;
                this.ids[n2] = id2++;
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.hashes, () -> this.blockFactory.adjustBreaker(-this.extraMemoryUsed)});
        }
    }
}

