/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.LongIntState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class LastIntByTimestampAggregator {
    public static String describe() {
        return "last_int_by_timestamp";
    }

    public static LongIntState initSingle(DriverContext driverContext) {
        return new LongIntState(0L, 0);
    }

    public static void first(LongIntState current, int value, long timestamp) {
        current.v1(timestamp);
        current.v2(value);
    }

    public static void combine(LongIntState current, int value, long timestamp) {
        if (timestamp > current.v1()) {
            current.v1(timestamp);
            current.v2(value);
        }
    }

    public static void combineIntermediate(LongIntState current, long timestamp, int value, boolean seen) {
        if (seen) {
            if (current.seen()) {
                LastIntByTimestampAggregator.combine(current, value, timestamp);
            } else {
                LastIntByTimestampAggregator.first(current, value, timestamp);
                current.seen(true);
            }
        }
    }

    public static Block evaluateFinal(LongIntState current, DriverContext ctx) {
        return ctx.blockFactory().newConstantIntBlockWith(current.v2(), 1);
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext.bigArrays());
    }

    public static void combine(GroupingState current, int groupId, int value, long timestamp) {
        current.collectValue(groupId, timestamp, value);
    }

    public static void combineIntermediate(GroupingState current, int groupId, LongBlock timestamps, IntBlock values, int otherPosition) {
        int valueCount = values.getValueCount(otherPosition);
        if (valueCount > 0) {
            long timestamp = timestamps.getLong(timestamps.getFirstValueIndex(otherPosition));
            int firstIndex = values.getFirstValueIndex(otherPosition);
            for (int i = 0; i < valueCount; ++i) {
                current.collectValue(groupId, timestamp, values.getInt(firstIndex + i));
            }
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.evaluateFinal(selected, ctx);
    }

    public static final class GroupingState
    extends AbstractArrayState {
        private final BigArrays bigArrays;
        private LongArray timestamps;
        private IntArray values;
        private int maxGroupId = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        GroupingState(BigArrays bigArrays) {
            super(bigArrays);
            this.bigArrays = bigArrays;
            boolean success = false;
            LongArray timestamps = null;
            try {
                this.timestamps = timestamps = bigArrays.newLongArray(1L, false);
                this.values = bigArrays.newIntArray(1L, false);
                this.enableGroupIdTracking(new SeenGroupIds.Empty());
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Releasables.close((Releasable[])new Releasable[]{timestamps, this.values, () -> super.close()});
                throw throwable;
            }
        }

        void collectValue(int groupId, long timestamp, int value) {
            boolean updated = false;
            if ((long)groupId < this.timestamps.size()) {
                if (groupId > this.maxGroupId || !this.hasValue(groupId) || this.timestamps.get((long)groupId) < timestamp) {
                    this.timestamps.set((long)groupId, timestamp);
                    updated = true;
                }
            } else {
                this.timestamps = this.bigArrays.grow(this.timestamps, (long)(groupId + 1));
                this.timestamps.set((long)groupId, timestamp);
                updated = true;
            }
            if (updated) {
                this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
                this.values.set((long)groupId, value);
            }
            this.maxGroupId = Math.max(this.maxGroupId, groupId);
            this.trackGroupId(groupId);
        }

        @Override
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.timestamps, this.values, () -> super.close()});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            try (LongBlock.Builder timestampsBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());
                 IntBlock.Builder valuesBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValue(group)) {
                        timestampsBuilder.appendLong(this.timestamps.get((long)group));
                        valuesBuilder.appendInt(this.values.get((long)group));
                        continue;
                    }
                    timestampsBuilder.appendNull();
                    valuesBuilder.appendNull();
                }
                blocks[offset] = timestampsBuilder.build();
                blocks[offset + 1] = valuesBuilder.build();
            }
        }

        Block evaluateFinal(IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
            try (IntBlock.Builder builder = evalContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValue(group)) {
                        builder.appendInt(this.values.get((long)group));
                        continue;
                    }
                    builder.appendNull();
                }
                IntBlock intBlock = builder.build();
                return intBlock;
            }
        }
    }
}

