/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.compute.aggregation.AbstractFallibleArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class FloatFallibleArrayState
extends AbstractFallibleArrayState
implements GroupingAggregatorState {
    private final float init;
    private FloatArray values;

    FloatFallibleArrayState(BigArrays bigArrays, float init) {
        super(bigArrays);
        this.values = bigArrays.newFloatArray(1L, false);
        this.values.set(0L, init);
        this.init = init;
    }

    float get(int groupId) {
        return this.values.get((long)groupId);
    }

    float getOrDefault(int groupId) {
        return (long)groupId < this.values.size() ? this.values.get((long)groupId) : this.init;
    }

    void set(int groupId, float value) {
        this.ensureCapacity(groupId);
        this.values.set((long)groupId, value);
        this.trackGroupId(groupId);
    }

    Block toValuesBlock(IntVector selected, DriverContext driverContext) {
        if (!this.trackingGroupIds() && !this.anyFailure()) {
            try (FloatVector.FixedBuilder builder = driverContext.blockFactory().newFloatVectorFixedBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    builder.appendFloat(i, this.values.get((long)selected.getInt(i)));
                }
                FloatBlock i = builder.build().asBlock();
                return i;
            }
        }
        try (FloatBlock.Builder builder = driverContext.blockFactory().newFloatBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group) && !this.hasFailed(group)) {
                    builder.appendFloat(this.values.get((long)group));
                    continue;
                }
                builder.appendNull();
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    private void ensureCapacity(int groupId) {
        if ((long)groupId >= this.values.size()) {
            long prevSize = this.values.size();
            this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
            this.values.fill(prevSize, this.values.size(), this.init);
        }
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 3);
        try (FloatBlock.Builder valuesBuilder = driverContext.blockFactory().newFloatBlockBuilder(selected.getPositionCount());
             BooleanVector.FixedBuilder hasValueBuilder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());
             BooleanVector.FixedBuilder hasFailedBuilder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if ((long)group < this.values.size()) {
                    valuesBuilder.appendFloat(this.values.get((long)group));
                } else {
                    valuesBuilder.appendFloat(0.0f);
                }
                hasValueBuilder.appendBoolean(i, this.hasValue(group));
                hasFailedBuilder.appendBoolean(i, this.hasFailed(group));
            }
            blocks[offset + 0] = valuesBuilder.build();
            blocks[offset + 1] = hasValueBuilder.build().asBlock();
            blocks[offset + 2] = hasFailedBuilder.build().asBlock();
        }
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, () -> super.close()});
    }
}

