/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import joptsimple.OptionSet;
import org.elasticsearch.Build;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.cli.EnvironmentAwareCommand;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.cli.InstallPluginAction;

class ListPluginsCommand
extends EnvironmentAwareCommand {
    ListPluginsCommand() {
        super("Lists installed elasticsearch plugins");
    }

    public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        if (!Files.exists(env.pluginsDir(), new LinkOption[0])) {
            throw new IOException("Plugins directory missing: " + String.valueOf(env.pluginsDir()));
        }
        terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Plugins directory: " + String.valueOf(env.pluginsDir())));
        ArrayList<Path> plugins = new ArrayList<Path>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(env.pluginsDir());){
            for (Path path : paths) {
                if (path.getFileName().toString().equals(".elasticsearch-plugins.yml.cache")) continue;
                plugins.add(path);
            }
        }
        Collections.sort(plugins);
        for (Path plugin : plugins) {
            ListPluginsCommand.printPlugin(env, terminal, plugin, "");
        }
    }

    private static void printPlugin(Environment env, Terminal terminal, Path plugin, String prefix) throws IOException {
        String buildVersion;
        terminal.println(Terminal.Verbosity.SILENT, (CharSequence)(prefix + plugin.getFileName().toString()));
        PluginDescriptor info = PluginDescriptor.readFromProperties((Path)env.pluginsDir().resolve(plugin));
        terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)info.toString(prefix));
        String semanticVersion = InstallPluginAction.getSemanticVersion(Build.current().version());
        String string = buildVersion = Objects.nonNull(semanticVersion) ? semanticVersion : Build.current().version();
        if (!info.getElasticsearchVersion().toString().equals(buildVersion)) {
            terminal.errorPrintln("WARNING: plugin [" + info.getName() + "] was built for Elasticsearch version " + info.getElasticsearchVersion() + " but version " + buildVersion + " is required");
        }
    }
}

