/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

public class HnswIndexParams {
    private CuvsHnswHierarchy hierarchy = CuvsHnswHierarchy.NONE;
    private int efConstruction = 200;
    private int numThreads = 2;
    private int vectorDimension;

    private HnswIndexParams(CuvsHnswHierarchy hierarchy, int efConstruction, int numThreads, int vectorDimension) {
        this.hierarchy = hierarchy;
        this.efConstruction = efConstruction;
        this.numThreads = numThreads;
        this.vectorDimension = vectorDimension;
    }

    public CuvsHnswHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public int getEfConstruction() {
        return this.efConstruction;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getVectorDimension() {
        return this.vectorDimension;
    }

    public String toString() {
        return "HnswIndexParams [hierarchy=" + String.valueOf((Object)this.hierarchy) + ", efConstruction=" + this.efConstruction + ", numThreads=" + this.numThreads + ", vectorDimension=" + this.vectorDimension + "]";
    }

    public static enum CuvsHnswHierarchy {
        NONE(0),
        CPU(1);

        public final int value;

        private CuvsHnswHierarchy(int value) {
            this.value = value;
        }
    }

    public static class Builder {
        private CuvsHnswHierarchy hierarchy = CuvsHnswHierarchy.NONE;
        private int efConstruction = 200;
        private int numThreads = 2;
        private int vectorDimension;

        public Builder withHierarchy(CuvsHnswHierarchy hierarchy) {
            this.hierarchy = hierarchy;
            return this;
        }

        public Builder withEfConstruction(int efConstruction) {
            this.efConstruction = efConstruction;
            return this;
        }

        public Builder withNumThreads(int numThreads) {
            this.numThreads = numThreads;
            return this;
        }

        public Builder withVectorDimension(int vectorDimension) {
            this.vectorDimension = vectorDimension;
            return this;
        }

        public HnswIndexParams build() {
            return new HnswIndexParams(this.hierarchy, this.efConstruction, this.numThreads, this.vectorDimension);
        }
    }
}

