/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CagraCompressionParams;
import com.nvidia.cuvs.CuVSIvfPqParams;

public class CagraIndexParams {
    private final CagraGraphBuildAlgo cuvsCagraGraphBuildAlgo;
    private final CuvsDistanceType cuvsDistanceType;
    private final int intermediateGraphDegree;
    private final int graphDegree;
    private final int nnDescentNiter;
    private final int numWriterThreads;
    private final CuVSIvfPqParams cuVSIvfPqParams;
    private final CagraCompressionParams cagraCompressionParams;

    private CagraIndexParams(int intermediateGraphDegree, int graphDegree, CagraGraphBuildAlgo CuvsCagraGraphBuildAlgo, int nnDescentNiter, int writerThreads, CuvsDistanceType cuvsDistanceType, CuVSIvfPqParams cuVSIvfPqParams, CagraCompressionParams cagraCompressionParams) {
        this.intermediateGraphDegree = intermediateGraphDegree;
        this.graphDegree = graphDegree;
        this.cuvsCagraGraphBuildAlgo = CuvsCagraGraphBuildAlgo;
        this.nnDescentNiter = nnDescentNiter;
        this.numWriterThreads = writerThreads;
        this.cuvsDistanceType = cuvsDistanceType;
        this.cuVSIvfPqParams = cuVSIvfPqParams;
        this.cagraCompressionParams = cagraCompressionParams;
    }

    public int getIntermediateGraphDegree() {
        return this.intermediateGraphDegree;
    }

    public int getGraphDegree() {
        return this.graphDegree;
    }

    public CagraGraphBuildAlgo getCagraGraphBuildAlgo() {
        return this.cuvsCagraGraphBuildAlgo;
    }

    public int getNNDescentNumIterations() {
        return this.nnDescentNiter;
    }

    public CuvsDistanceType getCuvsDistanceType() {
        return this.cuvsDistanceType;
    }

    public int getNumWriterThreads() {
        return this.numWriterThreads;
    }

    public CuVSIvfPqParams getCuVSIvfPqParams() {
        return this.cuVSIvfPqParams;
    }

    public CagraGraphBuildAlgo getCuvsCagraGraphBuildAlgo() {
        return this.cuvsCagraGraphBuildAlgo;
    }

    public int getNnDescentNiter() {
        return this.nnDescentNiter;
    }

    public CagraCompressionParams getCagraCompressionParams() {
        return this.cagraCompressionParams;
    }

    public String toString() {
        return "CagraIndexParams [cuvsCagraGraphBuildAlgo=" + String.valueOf((Object)this.cuvsCagraGraphBuildAlgo) + ", cuvsDistanceType=" + String.valueOf((Object)this.cuvsDistanceType) + ", intermediateGraphDegree=" + this.intermediateGraphDegree + ", graphDegree=" + this.graphDegree + ", nnDescentNiter=" + this.nnDescentNiter + ", numWriterThreads=" + this.numWriterThreads + ", cuVSIvfPqParams=" + String.valueOf(this.cuVSIvfPqParams) + ", cagraCompressionParams=" + String.valueOf(this.cagraCompressionParams) + "]";
    }

    public static enum CagraGraphBuildAlgo {
        AUTO_SELECT(0),
        IVF_PQ(1),
        NN_DESCENT(2);

        public final int value;

        private CagraGraphBuildAlgo(int value) {
            this.value = value;
        }
    }

    public static enum CuvsDistanceType {
        L2Expanded(0),
        L2SqrtExpanded(1),
        CosineExpanded(2),
        L1(3),
        L2Unexpanded(4),
        L2SqrtUnexpanded(5),
        InnerProduct(6),
        Linf(7),
        Canberra(8),
        LpUnexpanded(9),
        CorrelationExpanded(10),
        JaccardExpanded(11),
        HellingerExpanded(12),
        Haversine(13),
        BrayCurtis(14),
        JensenShannon(15),
        HammingUnexpanded(16),
        KLDivergence(17),
        RusselRaoExpanded(18),
        DiceExpanded(19),
        Precomputed(100);

        public final int value;

        private CuvsDistanceType(int value) {
            this.value = value;
        }
    }

    public static class Builder {
        private CagraGraphBuildAlgo cuvsCagraGraphBuildAlgo = CagraGraphBuildAlgo.NN_DESCENT;
        private CuvsDistanceType cuvsDistanceType = CuvsDistanceType.L2Expanded;
        private int intermediateGraphDegree = 128;
        private int graphDegree = 64;
        private int nnDescentNumIterations = 20;
        private int numWriterThreads = 2;
        private CuVSIvfPqParams cuVSIvfPqParams = new CuVSIvfPqParams.Builder().build();
        private CagraCompressionParams cagraCompressionParams;

        public Builder withIntermediateGraphDegree(int intermediateGraphDegree) {
            this.intermediateGraphDegree = intermediateGraphDegree;
            return this;
        }

        public Builder withGraphDegree(int graphDegree) {
            this.graphDegree = graphDegree;
            return this;
        }

        public Builder withCagraGraphBuildAlgo(CagraGraphBuildAlgo cuvsCagraGraphBuildAlgo) {
            this.cuvsCagraGraphBuildAlgo = cuvsCagraGraphBuildAlgo;
            return this;
        }

        public Builder withMetric(CuvsDistanceType cuvsDistanceType) {
            this.cuvsDistanceType = cuvsDistanceType;
            return this;
        }

        public Builder withNNDescentNumIterations(int nnDescentNiter) {
            this.nnDescentNumIterations = nnDescentNiter;
            return this;
        }

        public Builder withNumWriterThreads(int numWriterThreads) {
            this.numWriterThreads = numWriterThreads;
            return this;
        }

        public Builder withCuVSIvfPqParams(CuVSIvfPqParams cuVSIvfPqParams) {
            this.cuVSIvfPqParams = cuVSIvfPqParams;
            return this;
        }

        public Builder withCompressionParams(CagraCompressionParams cagraCompressionParams) {
            this.cagraCompressionParams = cagraCompressionParams;
            return this;
        }

        public CagraIndexParams build() {
            return new CagraIndexParams(this.intermediateGraphDegree, this.graphDegree, this.cuvsCagraGraphBuildAlgo, this.nnDescentNumIterations, this.numWriterThreads, this.cuvsDistanceType, this.cuVSIvfPqParams, this.cagraCompressionParams);
        }
    }

    public static enum CudaDataType {
        CUDA_R_16F(2),
        CUDA_C_16F(6),
        CUDA_R_16BF(14),
        CUDA_C_16BF(15),
        CUDA_R_32F(0),
        CUDA_C_32F(4),
        CUDA_R_64F(1),
        CUDA_C_64F(5),
        CUDA_R_4I(16),
        CUDA_C_4I(17),
        CUDA_R_4U(18),
        CUDA_C_4U(19),
        CUDA_R_8I(3),
        CUDA_C_8I(7),
        CUDA_R_8U(8),
        CUDA_C_8U(9),
        CUDA_R_16I(20),
        CUDA_C_16I(21),
        CUDA_R_16U(22),
        CUDA_C_16U(23),
        CUDA_R_32I(10),
        CUDA_C_32I(11),
        CUDA_R_32U(12),
        CUDA_C_32U(13),
        CUDA_R_64I(24),
        CUDA_C_64I(25),
        CUDA_R_64U(26),
        CUDA_C_64U(27),
        CUDA_R_8F_E4M3(28),
        CUDA_R_8F_E5M2(29);

        public final int value;

        private CudaDataType(int value) {
            this.value = value;
        }
    }

    public static enum CodebookGen {
        PER_SUBSPACE(0),
        PER_CLUSTER(1);

        public final int value;

        private CodebookGen(int value) {
            this.value = value;
        }
    }
}

