/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal;

import com.nvidia.cuvs.CuVSMatrix;
import com.nvidia.cuvs.internal.CuVSHostMatrixImpl;
import java.lang.foreign.Arena;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.ValueLayout;
import java.util.concurrent.atomic.AtomicReference;

public class CuVSHostMatrixArenaImpl
extends CuVSHostMatrixImpl {
    private final AtomicReference<Arena> arenaReference;

    public CuVSHostMatrixArenaImpl(long size, long columns, CuVSMatrix.DataType dataType) {
        this(size, columns, -1, -1, dataType, CuVSHostMatrixArenaImpl.valueLayoutFromType(dataType), CuVSHostMatrixArenaImpl.sequenceLayoutFromType(size, columns, -1, dataType), Arena.ofShared());
    }

    public CuVSHostMatrixArenaImpl(long size, long columns, int rowStride, int columnStride, CuVSMatrix.DataType dataType) {
        this(size, columns, rowStride, columnStride, dataType, CuVSHostMatrixArenaImpl.valueLayoutFromType(dataType), CuVSHostMatrixArenaImpl.sequenceLayoutFromType(size, columns, rowStride, dataType), Arena.ofShared());
    }

    private CuVSHostMatrixArenaImpl(long size, long columns, int rowStride, int columnStride, CuVSMatrix.DataType dataType, ValueLayout valueLayout, SequenceLayout layout, Arena arena) {
        super(arena.allocate(layout), size, columns, rowStride, columnStride, dataType, valueLayout, layout);
        if (columnStride != -1) {
            throw new UnsupportedOperationException("Stridden columns are currently not supported; columnStride must be equal to -1");
        }
        this.arenaReference = new AtomicReference<Arena>(arena);
    }

    @Override
    public void close() {
        Arena arena = this.arenaReference.getAndSet(null);
        if (arena != null) {
            arena.close();
        }
    }
}

