/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.core.enrich.action.GetEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.EnrichStore;

public class TransportGetEnrichPolicyAction
extends TransportLocalProjectMetadataAction<GetEnrichPolicyAction.Request, GetEnrichPolicyAction.Response> {
    @Inject
    public TransportGetEnrichPolicyAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super("cluster:admin/xpack/enrich/get", actionFilters, transportService.getTaskManager(), clusterService, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, projectResolver);
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetEnrichPolicyAction.Request::new, (request, channel, task) -> this.executeDirect(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel)));
    }

    protected void localClusterStateOperation(Task task, GetEnrichPolicyAction.Request request, ProjectState state, ActionListener<GetEnrichPolicyAction.Response> listener) throws Exception {
        Map<String, EnrichPolicy> policies;
        if (request.getNames() == null || request.getNames().isEmpty()) {
            policies = EnrichStore.getPolicies(state.metadata());
        } else {
            policies = new HashMap<String, EnrichPolicy>();
            for (String name : request.getNames()) {
                EnrichPolicy policy;
                if (name.isEmpty() || (policy = EnrichStore.getPolicy(name, state.metadata())) == null) continue;
                policies.put(name, policy);
            }
        }
        ((CancellableTask)task).ensureNotCancelled();
        listener.onResponse((Object)new GetEnrichPolicyAction.Response(policies));
    }

    protected ClusterBlockException checkBlock(GetEnrichPolicyAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ);
    }
}

