/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.hadoop.cli.ConsolePrompt;
import org.elasticsearch.hadoop.cli.Prompt;
import org.elasticsearch.hadoop.security.EsHadoopSecurityException;
import org.elasticsearch.hadoop.security.KeystoreWrapper;

public class Keytool {
    private static final String KEYSTORE_FILE_NAME = "esh.keystore";
    private static final String TBLFRMT = "%-15s%-19s%n";
    private static final String FLAG_HELP = "--help";
    private static final String FLAG_H = "-h";
    private static final String FLAG_FORCE = "--force";
    private static final String FLAG_F = "-f";
    private static final String FLAG_STDIN = "--stdin";
    private final Prompt prompt;
    private final Command command;

    public static void main(String[] args) {
        System.exit(Keytool.execute(new ConsolePrompt(), args));
    }

    public static int execute(Prompt console, String[] args) {
        Command command = null;
        String commandArg = null;
        boolean hasSTDIN = false;
        boolean force = false;
        for (int idx = 0; idx < args.length; ++idx) {
            String arg = args[idx];
            if (arg.equals(FLAG_H) || arg.equals(FLAG_HELP)) {
                Keytool.printUsage(console);
                return 0;
            }
            if (!hasSTDIN && arg.equals(FLAG_STDIN)) {
                hasSTDIN = true;
                continue;
            }
            if (!force && (arg.equals(FLAG_F) || arg.equals(FLAG_FORCE))) {
                force = true;
                continue;
            }
            if (command == null) {
                command = Command.byName(arg.toLowerCase());
                if (command != null) continue;
                Keytool.printUsage(console);
                Keytool.error(console, "Unknown command [" + arg + "]");
                return 2;
            }
            if (command.hasArgs() && commandArg == null) {
                commandArg = arg;
                continue;
            }
            Keytool.printUsage(console);
            Keytool.error(console, "Unexpected argument [" + arg + "]");
            return 3;
        }
        if (command == null) {
            Keytool.printUsage(console);
            Keytool.error(console, "No command specified");
            return 1;
        }
        if (command.hasArgs && commandArg == null) {
            Keytool.printUsage(console);
            Keytool.error(console, "Settings name required for command [" + command.text + "]");
            return 4;
        }
        hasSTDIN |= System.console() == null;
        try {
            return new Keytool(console, command).run(commandArg, hasSTDIN, force);
        }
        catch (IOException e) {
            console.println("ERROR: " + e.getMessage());
            return 11;
        }
    }

    private static void printUsage(Prompt prompt) {
        prompt.println("A tool for managing settings stored in an ES-Hadoop keystore");
        prompt.println();
        prompt.println("Commands");
        prompt.println("--------");
        prompt.println(Command.CREATE.getText() + " - Creates a new elasticsearch keystore");
        prompt.println(Command.LIST.getText() + " - List entries in the keystore");
        prompt.println(Command.ADD.getText() + " - Add a setting to the keystore");
        prompt.println(Command.REMOVE.getText() + " - Remove a setting from the keystore");
        prompt.println();
        prompt.printf(TBLFRMT, "Option", "Description");
        prompt.printf(TBLFRMT, "------", "-----------");
        prompt.printf(TBLFRMT, "-h, --help", "show help");
        prompt.printf(TBLFRMT, "-f, --force", "ignore overwriting warnings when adding to the keystore");
    }

    private static void error(Prompt prompt, String error) {
        prompt.println("ERROR: " + error);
    }

    Keytool(Prompt prompt, Command command) {
        this.prompt = prompt;
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String arg, boolean stdin, boolean force) throws IOException {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            switch (this.command.ordinal()) {
                case 0: {
                    int proceed2;
                    if (this.ksExists() && (proceed2 = this.promptYesNo("An es-hadoop keystore already exists. Overwrite? [y/N]", new Object[0])) == 0) {
                        this.prompt.println("Exiting without creating keystore");
                        int n = 0;
                        return n;
                    }
                    KeystoreWrapper keystoreWrapper = KeystoreWrapper.newStore().build();
                    outputStream = this.openWrite();
                    keystoreWrapper.saveKeystore(outputStream);
                    proceed2 = 0;
                    return proceed2;
                }
                case 1: {
                    if (!this.ksExists()) {
                        this.prompt.printf("ERROR: ES-Hadoop keystore not found. Use '%s' command to create one.%n", Command.CREATE.getText());
                        int proceed2 = 5;
                        return proceed2;
                    }
                    inputStream = this.openRead();
                    KeystoreWrapper keystoreWrapper = KeystoreWrapper.loadStore(inputStream).build();
                    for (String entry : keystoreWrapper.listEntries()) {
                        this.prompt.println(entry);
                    }
                    int proceed2 = 0;
                    return proceed2;
                }
                case 2: {
                    Object data;
                    int proceed2;
                    if (!this.ksExists()) {
                        this.prompt.printf("ERROR: ES-Hadoop keystore not found. Use '%s' command to create one.%n", Command.CREATE.getText());
                        int proceed2 = 5;
                        return proceed2;
                    }
                    inputStream = this.openRead();
                    KeystoreWrapper keystoreWrapper = KeystoreWrapper.loadStore(inputStream).build();
                    if (keystoreWrapper.containsEntry(arg) && !force && (proceed2 = (int)(this.promptYesNo("Setting %s already exists. Overwrite? [y/N]", arg) ? 1 : 0)) == 0) {
                        this.prompt.println("Exiting without modifying keystore");
                        int n = 0;
                        return n;
                    }
                    if (stdin) {
                        data = this.prompt.readLine();
                        keystoreWrapper.setSecureSetting(arg, (String)data);
                    } else {
                        data = this.prompt.readPassword("Enter value for %s:", arg);
                        keystoreWrapper.setSecureSetting(arg, new String((char[])data));
                        Arrays.fill((char[])data, '\u0000');
                    }
                    outputStream = this.openWrite();
                    keystoreWrapper.saveKeystore(outputStream);
                    int data2 = 0;
                    return data2;
                }
                case 3: {
                    if (!this.ksExists()) {
                        this.prompt.printf("ERROR: ES-Hadoop keystore not found. Use '%s' command to create one.%n", Command.CREATE.getText());
                        int data2 = 5;
                        return data2;
                    }
                    inputStream = this.openRead();
                    KeystoreWrapper keystoreWrapper = KeystoreWrapper.loadStore(inputStream).build();
                    if (!keystoreWrapper.containsEntry(arg)) {
                        this.prompt.printf("ERROR: Setting [%s] does not exist in the keystore.%n", arg);
                        int data2 = 6;
                        return data2;
                    }
                    keystoreWrapper.removeSecureSetting(arg);
                    outputStream = this.openWrite();
                    keystoreWrapper.saveKeystore(outputStream);
                    int data2 = 0;
                    return data2;
                }
            }
            this.prompt.println("ERROR: Unsupported command " + this.command.getText());
            int data2 = 7;
            return data2;
        }
        catch (EsHadoopSecurityException ehse) {
            this.prompt.println("ERRORCould not load keystore file: " + ehse.getMessage());
            int n = 8;
            return n;
        }
        catch (FileNotFoundException fnfe) {
            this.prompt.println("ERROR: Could not load keystore file: " + fnfe.getMessage());
            int n = 9;
            return n;
        }
        catch (IOException ioe) {
            this.prompt.println("ERROR: " + ioe.getMessage());
            int n = 10;
            return n;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private boolean promptYesNo(String msgFormat, Object ... args) {
        String response;
        while ((response = this.prompt.readLine(msgFormat, args)) != null && !response.isEmpty() && !response.equalsIgnoreCase("n")) {
            if (response.equalsIgnoreCase("y")) {
                return true;
            }
            this.prompt.printf("Did not understand answer '%s'%n", response);
        }
        return false;
    }

    protected boolean ksExists() {
        File file = new File(KEYSTORE_FILE_NAME);
        return file.exists();
    }

    protected InputStream openRead() throws FileNotFoundException {
        File file = new File(KEYSTORE_FILE_NAME);
        return new FileInputStream(file);
    }

    protected OutputStream openWrite() throws IOException {
        File file = new File(KEYSTORE_FILE_NAME);
        if (file.exists()) {
            file.createNewFile();
        }
        return new FileOutputStream(file);
    }

    static enum Command {
        CREATE("create", false),
        LIST("list", false),
        ADD("add", true),
        REMOVE("remove", true);

        private final String text;
        private final boolean hasArgs;
        private static Map<String, Command> lookup;

        private Command(String text, boolean hasArgs) {
            this.text = text;
            this.hasArgs = hasArgs;
        }

        public String getText() {
            return this.text;
        }

        public boolean hasArgs() {
            return this.hasArgs;
        }

        public static Command byName(String name) {
            return lookup.get(name);
        }

        static {
            lookup = new HashMap<String, Command>();
            lookup.put(Command.CREATE.text, CREATE);
            lookup.put(Command.LIST.text, LIST);
            lookup.put(Command.ADD.text, ADD);
            lookup.put(Command.REMOVE.text, REMOVE);
        }
    }
}

