/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.security.EsHadoopSecurityException;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class KeystoreWrapper {
    private static final String PKCS12 = "PKCS12";
    private static final String AES = "AES";
    private static final String DEFAULT_PASS = "";
    private final KeyStore keyStore;
    private final KeyStore.PasswordProtection protection;

    private KeystoreWrapper(InputStream inputStream, String type, String password) throws EsHadoopSecurityException, IOException {
        Assert.notNull(password, "Password should not be null");
        try {
            char[] pwd = password.toCharArray();
            this.protection = new KeyStore.PasswordProtection(pwd);
            this.keyStore = KeyStore.getInstance(type);
            this.keyStore.load(inputStream, pwd);
        }
        catch (CertificateException e) {
            throw new EsHadoopSecurityException("Could not create keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EsHadoopSecurityException("Could not create keystore", e);
        }
        catch (KeyStoreException e) {
            throw new EsHadoopSecurityException("Could not create keystore", e);
        }
    }

    public void setSecureSetting(String alias, String key) throws EsHadoopSecurityException {
        SecretKeySpec spec = new SecretKeySpec(key.getBytes(), AES);
        KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(spec);
        try {
            this.keyStore.setEntry(alias, entry, this.protection);
        }
        catch (KeyStoreException e) {
            throw new EsHadoopSecurityException(String.format("Could not store secret key (alias : [%s]) in keystore", alias), e);
        }
    }

    public void removeSecureSetting(String alias) throws EsHadoopSecurityException {
        try {
            this.keyStore.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new EsHadoopSecurityException(String.format("Could not delete secret key (alias : [%s]) from keystore", alias), e);
        }
    }

    public String getSecureSetting(String alias) throws EsHadoopSecurityException {
        try {
            if (!this.keyStore.containsAlias(alias)) {
                return null;
            }
            KeyStore.Entry entry = this.keyStore.getEntry(alias, this.protection);
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
            return new String(secretKeyEntry.getSecretKey().getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            throw new EsHadoopSecurityException(String.format("Could not read alias [%s] from keystore", alias), e);
        }
        catch (UnrecoverableEntryException e) {
            throw new EsHadoopSecurityException(String.format("Could not read alias [%s] from keystore", alias), e);
        }
        catch (KeyStoreException e) {
            throw new EsHadoopSecurityException(String.format("Could not read alias [%s] from keystore", alias), e);
        }
    }

    public boolean containsEntry(String alias) throws EsHadoopSecurityException {
        try {
            return this.keyStore.containsAlias(alias);
        }
        catch (KeyStoreException e) {
            throw new EsHadoopSecurityException(String.format("Could not read existence of alias [%s]", alias), e);
        }
    }

    public List<String> listEntries() throws EsHadoopSecurityException {
        try {
            ArrayList<String> entries = new ArrayList<String>(this.keyStore.size());
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                entries.add(alias);
            }
            return entries;
        }
        catch (KeyStoreException e) {
            throw new EsHadoopSecurityException("Could not read aliases from keystore", e);
        }
    }

    public void saveKeystore(OutputStream outputStream) throws EsHadoopSecurityException, IOException {
        try {
            this.keyStore.store(outputStream, this.protection.getPassword());
        }
        catch (KeyStoreException e) {
            throw new EsHadoopSecurityException("Could not persist keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EsHadoopSecurityException("Could not persist keystore", e);
        }
        catch (CertificateException e) {
            throw new EsHadoopSecurityException("Could not persist keystore", e);
        }
    }

    public void saveKeystore(String path) throws EsHadoopSecurityException, IOException {
        try (OutputStream stream = null;){
            stream = new FileOutputStream(new File(path));
            this.saveKeystore(stream);
        }
    }

    public static KeystoreBuilder loadStore(String path) {
        return new KeystoreBuilder(path);
    }

    public static KeystoreBuilder loadStore(InputStream stream) {
        return new KeystoreBuilder(stream);
    }

    public static KeystoreBuilder newStore() {
        return new KeystoreBuilder();
    }

    public static final class KeystoreBuilder {
        private String type;
        private String password;
        private String path;
        private InputStream keystoreFile;

        private KeystoreBuilder(InputStream keystoreFile) {
            this.keystoreFile = keystoreFile;
        }

        private KeystoreBuilder(String path) {
            this.path = path;
        }

        private KeystoreBuilder() {
        }

        public KeystoreBuilder setType(String type) {
            this.type = type;
            return this;
        }

        public KeystoreBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public KeystoreWrapper build() throws EsHadoopSecurityException, IOException {
            if (StringUtils.hasText(this.path)) {
                try {
                    this.keystoreFile = IOUtils.open(this.path);
                    if (this.keystoreFile == null) {
                        throw new EsHadoopIllegalArgumentException(String.format("Could not locate [%s] on classpath", this.path));
                    }
                }
                catch (Exception e) {
                    throw new EsHadoopIllegalArgumentException(String.format("Expected to find keystore file at [%s] but was unable to. Make sure that it is available on the classpath, or if not, that you have specified a valid file URI.", this.path));
                }
            }
            if (!StringUtils.hasText(this.type)) {
                this.type = KeystoreWrapper.PKCS12;
            }
            if (!StringUtils.hasText(this.password)) {
                this.password = KeystoreWrapper.DEFAULT_PASS;
            }
            return new KeystoreWrapper(this.keystoreFile, this.type, this.password);
        }
    }
}

